/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.utils.BlockUtils;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class AIRobotPumpBlock
extends AIRobot {
    public BlockIndex blockToPump;
    public long waited = 0L;
    int pumped = 0;

    public AIRobotPumpBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPumpBlock(EntityRobotBase iRobot, BlockIndex iBlockToPump) {
        super(iRobot);
        this.blockToPump = iBlockToPump;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToPump.x, this.blockToPump.y, this.blockToPump.z);
    }

    @Override
    public void preempt(AIRobot ai) {
        super.preempt(ai);
    }

    @Override
    public void update() {
        if (this.waited < 40L) {
            ++this.waited;
        } else {
            FluidStack fluidStack = BlockUtils.drainBlock(this.robot.worldObj, this.blockToPump.x, this.blockToPump.y, this.blockToPump.z, false);
            if (fluidStack != null && this.robot.fill(ForgeDirection.UNKNOWN, fluidStack, true) > 0) {
                BlockUtils.drainBlock(this.robot.worldObj, this.blockToPump.x, this.blockToPump.y, this.blockToPump.z, true);
            }
            this.terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 5;
    }

    @Override
    public boolean success() {
        return this.pumped > 0;
    }
}

