/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.IPipeTile;
import buildcraft.robots.DockingStation;
import buildcraft.robots.IStationFilter;
import buildcraft.robots.ai.AIRobotSearchAndGotoStation;
import buildcraft.transport.PipeTransportPower;

public class AIRobotRecharge
extends AIRobot {
    private DockingStation axeDocking = null;

    public AIRobotRecharge(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void start() {
        this.robot.getRegistry().releaseResources(this.robot);
        this.robot.motionX = 0.0;
        this.robot.motionY = 0.0;
        this.robot.motionZ = 0.0;
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new IStationFilter(){

            @Override
            public boolean matches(DockingStation station) {
                return station.getPipe().getPipeType() == IPipeTile.PipeType.POWER;
            }
        }, null));
    }

    @Override
    public int getEnergyCost() {
        return 0;
    }

    @Override
    public void update() {
        if (this.robot.getEnergy() >= 99500) {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation && (this.robot.getDockingStation() == null || !(((DockingStation)this.robot.getDockingStation()).getPipe().pipe.transport instanceof PipeTransportPower))) {
            this.terminate();
        }
    }
}

