/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.utils.IBlockFilter;
import buildcraft.core.utils.concurrency.IterableAlgorithmRunner;
import buildcraft.core.utils.concurrency.PathFindingSearch;
import buildcraft.robots.ResourceIdBlock;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotSearchBlockBase
extends AIRobot {
    public BlockIndex blockFound;
    public LinkedList<BlockIndex> path;
    private PathFindingSearch blockScanner = null;
    private IterableAlgorithmRunner blockScannerJob;
    private IBlockFilter pathFound;
    private Iterator<BlockIndex> blockIter;

    public AIRobotSearchBlockBase(EntityRobotBase iRobot, IBlockFilter iPathFound, Iterator<BlockIndex> iBlockIter) {
        super(iRobot);
        this.pathFound = iPathFound;
        this.blockIter = iBlockIter;
        this.blockFound = null;
        this.path = null;
    }

    @Override
    public void start() {
        this.blockScanner = new PathFindingSearch(this.robot.worldObj, new BlockIndex((Entity)this.robot), this.blockIter, this.pathFound, 96.0f, this.robot.getZoneToWork());
        this.blockScannerJob = new IterableAlgorithmRunner(this.blockScanner);
        this.blockScannerJob.start();
    }

    @Override
    public void update() {
        if (this.blockScannerJob == null) {
            this.abort();
            return;
        }
        if (this.blockScannerJob.isDone()) {
            this.path = this.blockScanner.getResult();
            if (this.path != null && this.path.size() > 0) {
                this.blockFound = this.path.removeLast();
            } else {
                this.path = null;
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        if (this.blockScannerJob != null) {
            this.blockScannerJob.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockFound")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("blockFound"));
        }
    }

    public boolean takeResource() {
        boolean taken = false;
        if (this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(this.blockFound), this.robot)) {
            taken = true;
        }
        this.unreserve();
        return taken;
    }

    public void unreserve() {
        this.blockScanner.unreserve(this.blockFound);
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

