/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.TransactorSimple;
import buildcraft.core.utils.IEntityFilter;
import net.minecraft.entity.Entity;

public class AIRobotSearchEntity
extends AIRobot {
    public Entity target;
    private float maxRange;
    private IZone zone;
    private IEntityFilter filter;

    public AIRobotSearchEntity(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchEntity(EntityRobotBase iRobot, IEntityFilter iFilter, float iMaxRange, IZone iZone) {
        super(iRobot);
        this.maxRange = iMaxRange;
        this.zone = iZone;
        this.filter = iFilter;
    }

    @Override
    public void start() {
        double previousDistance = Double.MAX_VALUE;
        TransactorSimple inventoryInsert = new TransactorSimple(this.robot);
        for (Object o : this.robot.worldObj.loadedEntityList) {
            double maxDistance;
            double dz;
            double dy;
            double dx;
            double sqrDistance;
            Entity e = (Entity)o;
            if (e.isDead || !this.filter.matches(e) || this.zone != null && !this.zone.contains(e.posX, e.posY, e.posZ) || this.robot.isKnownUnreachable(e) || (sqrDistance = (dx = e.posX - this.robot.posX) * dx + (dy = e.posY - this.robot.posY) * dy + (dz = e.posZ - this.robot.posZ) * dz) >= (maxDistance = (double)(this.maxRange * this.maxRange))) continue;
            if (this.target == null) {
                previousDistance = sqrDistance;
                this.target = e;
                continue;
            }
            if (!(sqrDistance < previousDistance)) continue;
            previousDistance = sqrDistance;
            this.target = e;
        }
        this.terminate();
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

