/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.utils.IBlockFilter;

public class AIRobotSearchRandomGroundBlock
extends AIRobot {
    private static final int MAX_ATTEMPTS = 4096;
    public BlockIndex blockFound;
    private int range;
    private IBlockFilter filter;
    private IZone zone;
    private int attempts = 0;

    public AIRobotSearchRandomGroundBlock(EntityRobotBase iRobot, int iRange, IBlockFilter iFilter, IZone iZone) {
        super(iRobot);
        this.range = iRange;
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void update() {
        if (this.filter == null) {
            this.terminate();
        }
        ++this.attempts;
        if (this.attempts > 4096) {
            this.terminate();
        }
        int x = 0;
        int z = 0;
        if (this.zone == null) {
            double r = this.robot.worldObj.rand.nextFloat() * (float)this.range;
            double a = (double)this.robot.worldObj.rand.nextFloat() * 2.0 * Math.PI;
            x = (int)(Math.cos(a) * r + Math.floor(this.robot.posX));
            z = (int)(Math.sin(a) * r + Math.floor(this.robot.posZ));
        } else {
            BlockIndex b = this.zone.getRandomBlockIndex(this.robot.worldObj.rand);
            x = b.x;
            z = b.z;
        }
        for (int y = this.robot.worldObj.getHeight(); y >= 0; --y) {
            if (this.filter.matches(this.robot.worldObj, x, y, z)) {
                this.blockFound = new BlockIndex(x, y, z);
                this.terminate();
                return;
            }
            if (this.robot.worldObj.isAirBlock(x, y, z)) continue;
            return;
        }
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

