/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.robots.DockingStation;
import buildcraft.robots.IStationFilter;
import buildcraft.robots.statements.ActionStationForbidRobot;

public class AIRobotSearchStation
extends AIRobot {
    public DockingStation targetStation;
    private IStationFilter filter;
    private IZone zone;

    public AIRobotSearchStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchStation(EntityRobotBase iRobot, IStationFilter iFilter, IZone iZone) {
        super(iRobot);
        this.filter = iFilter;
        this.zone = iZone;
    }

    @Override
    public void start() {
        if (this.robot.getDockingStation() != null && this.filter.matches((DockingStation)this.robot.getDockingStation())) {
            this.targetStation = (DockingStation)this.robot.getDockingStation();
            this.terminate();
            return;
        }
        double potentialStationDistance = 3.4028234663852886E38;
        DockingStation potentialStation = null;
        for (IDockingStation d : this.robot.getRegistry().getStations()) {
            DockingStation station = (DockingStation)d;
            if (d.isTaken() && d.robotIdTaking() != this.robot.getRobotId() || this.zone != null && !this.zone.contains(d.x(), d.y(), d.z()) || !this.filter.matches(station) || ActionStationForbidRobot.isForbidden(station, this.robot)) continue;
            double dx = this.robot.posX - (double)d.x();
            double dy = this.robot.posY - (double)d.y();
            double dz = this.robot.posZ - (double)d.z();
            double distance = dx * dx + dy * dy + dz * dz;
            if (potentialStation != null && !(distance < potentialStationDistance)) continue;
            potentialStation = station;
            potentialStationDistance = distance;
        }
        if (potentialStation != null) {
            this.targetStation = potentialStation;
        }
        this.terminate();
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        this.terminate();
    }

    @Override
    public boolean success() {
        return this.targetStation != null;
    }
}

