/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.statements.ActionStationInputItems;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotUnload
extends AIRobot {
    private int waitedCycles = 0;
    private boolean delivered = false;

    public AIRobotUnload(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void update() {
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            if (!this.doUnload()) {
                this.terminate();
            } else {
                this.waitedCycles = 0;
            }
        }
    }

    private boolean doUnload() {
        DockingStation station = (DockingStation)this.robot.getDockingStation();
        if (station == null) {
            return false;
        }
        Pipe pipe = station.getPipe().pipe;
        for (IInvSlot robotSlot : InventoryIterator.getIterable(this.robot, ForgeDirection.UNKNOWN)) {
            if (robotSlot.getStackInSlot() == null) continue;
            for (StatementSlot s : new ActionIterator(pipe)) {
                if (!(s.statement instanceof ActionStationInputItems) || !((ActionStationInputItems)s.statement).insert(station, (EntityRobot)this.robot, s, robotSlot, true)) continue;
                this.delivered = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getEnergyCost() {
        return 10;
    }

    @Override
    public boolean success() {
        return this.delivered;
    }
}

