/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotUseToolOnBlock
extends AIRobot {
    private BlockIndex useToBlock;
    private int useCycles = 0;

    public AIRobotUseToolOnBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotUseToolOnBlock(EntityRobotBase iRobot, BlockIndex index) {
        super(iRobot);
        this.useToBlock = index;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.useToBlock.x, this.useToBlock.y, this.useToBlock.z);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        ++this.useCycles;
        if (this.useCycles > 40) {
            ItemStack stack = this.robot.getHeldItem();
            if (this.robot.getHeldItem().isItemStackDamageable()) {
                this.robot.getHeldItem().damageItem(1, (EntityLivingBase)this.robot);
                if (this.robot.getHeldItem().getItemDamage() >= this.robot.getHeldItem().getMaxDamage()) {
                    this.robot.setItemInUse(null);
                }
            } else {
                this.robot.setItemInUse(null);
            }
            stack.getItem().onItemUse(stack, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.worldObj).get(), this.robot.worldObj, this.useToBlock.x, this.useToBlock.y, this.useToBlock.z, ForgeDirection.UP.ordinal(), 0.0f, 0.0f, 0.0f);
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public int getEnergyCost() {
        return 8;
    }
}

