/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.utils.IBlockFilter;
import buildcraft.robots.ai.AIRobotGotoBlock;
import buildcraft.robots.ai.AIRobotGotoStationToLoad;
import buildcraft.robots.ai.AIRobotLoad;
import buildcraft.robots.ai.AIRobotSearchRandomGroundBlock;
import buildcraft.robots.boards.BoardRobotBomberNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BoardRobotBomber
extends RedstoneBoardRobot {
    private static final IStackFilter TNT_FILTER = new ArrayStackFilter(new ItemStack(Blocks.tnt));
    private BlockIndex target = null;
    private int flyingHeight = 20;

    public BoardRobotBomber(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotBomberNBT.instance;
    }

    @Override
    public final void update() {
        boolean containItems = false;
        for (int i = 0; i < this.robot.getSizeInventory(); ++i) {
            if (this.robot.getStackInSlot(i) == null) continue;
            containItems = true;
        }
        if (!containItems) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, TNT_FILTER, null));
        } else {
            this.startDelegateAI(new AIRobotSearchRandomGroundBlock(this.robot, 100, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return y < world.getActualHeight() - BoardRobotBomber.this.flyingHeight && !world.isAirBlock(x, y, z);
                }
            }, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        ITransactor t;
        ItemStack stack;
        if (ai instanceof AIRobotGotoStationToLoad) {
            this.startDelegateAI(new AIRobotLoad(this.robot, TNT_FILTER));
        } else if (ai instanceof AIRobotSearchRandomGroundBlock) {
            AIRobotSearchRandomGroundBlock aiFind = (AIRobotSearchRandomGroundBlock)ai;
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, aiFind.blockFound.x, aiFind.blockFound.y + this.flyingHeight, aiFind.blockFound.z));
        } else if (ai instanceof AIRobotGotoBlock && (stack = (t = Transactor.getTransactorFor((Object)this.robot)).remove(TNT_FILTER, ForgeDirection.UNKNOWN, true)) != null && stack.stackSize > 0) {
            EntityTNTPrimed tnt = new EntityTNTPrimed(this.robot.worldObj, this.robot.posX + 0.25, this.robot.posY - 1.0, this.robot.posZ + 0.25, (EntityLivingBase)this.robot);
            tnt.fuse = 37;
            this.robot.worldObj.spawnEntityInWorld((Entity)tnt);
            this.robot.worldObj.playSoundAtEntity((Entity)tnt, "game.tnt.primed", 1.0f, 1.0f);
        }
    }
}

