/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotGotoStationAndUnload;
import buildcraft.robots.ai.AIRobotGotoStationToLoad;
import buildcraft.robots.ai.AIRobotLoad;
import buildcraft.robots.boards.BoardRobotCarrierNBT;
import buildcraft.robots.statements.ActionRobotFilter;

public class BoardRobotCarrier
extends RedstoneBoardRobot {
    private boolean loadFound = true;
    private boolean unloadFound = true;

    public BoardRobotCarrier(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotCarrierNBT.instance;
    }

    @Override
    public void update() {
        if (!this.robot.containsItems()) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
        } else {
            this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToLoad) {
            if (ai.success()) {
                this.loadFound = true;
                this.startDelegateAI(new AIRobotLoad(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation())));
            } else {
                this.loadFound = false;
                if (this.robot.containsItems()) {
                    this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot, this.robot.getZoneToWork()));
                } else {
                    this.unloadFound = false;
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndUnload) {
            if (ai.success()) {
                this.unloadFound = true;
            } else {
                this.unloadFound = false;
                this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
            }
        }
        if (!this.loadFound && !this.unloadFound) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            this.loadFound = true;
            this.unloadFound = true;
        }
    }
}

