/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.StackRequest;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.robots.ai.AIRobotDeliverRequested;
import buildcraft.robots.ai.AIRobotDisposeItems;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotGotoStationAndLoad;
import buildcraft.robots.ai.AIRobotSearchStackRequest;
import buildcraft.robots.boards.BoardRobotDeliveryNBT;
import buildcraft.robots.statements.ActionRobotFilter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class BoardRobotDelivery
extends RedstoneBoardRobot {
    private ArrayList<ItemStack> deliveryBlacklist = new ArrayList();
    private StackRequest currentRequest = null;

    public BoardRobotDelivery(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotDeliveryNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.containsItems()) {
            this.startDelegateAI(new AIRobotDisposeItems(this.robot));
            return;
        }
        if (this.currentRequest == null) {
            this.startDelegateAI(new AIRobotSearchStackRequest(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.deliveryBlacklist));
        } else {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new ReqFilter(), this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStackRequest) {
            if (!ai.success()) {
                this.deliveryBlacklist.clear();
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.currentRequest = ((AIRobotSearchStackRequest)ai).request;
                if (!this.currentRequest.station.take(this.robot)) {
                    this.currentRequest = null;
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndLoad) {
            if (!ai.success()) {
                this.deliveryBlacklist.add(this.currentRequest.stack);
                this.robot.releaseResources();
                this.currentRequest = null;
            } else {
                this.startDelegateAI(new AIRobotDeliverRequested(this.robot, this.currentRequest));
            }
        } else if (ai instanceof AIRobotDeliverRequested) {
            this.robot.releaseResources();
            this.currentRequest = null;
        }
    }

    private class ReqFilter
    implements IStackFilter {
        private ReqFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (BoardRobotDelivery.this.currentRequest == null) {
                return false;
            }
            return StackHelper.isMatchingItemOrList(stack, ((BoardRobotDelivery)BoardRobotDelivery.this).currentRequest.stack);
        }
    }
}

