/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.utils.IBlockFilter;
import buildcraft.robots.ResourceIdBlock;
import buildcraft.robots.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robots.ai.AIRobotGotoBlock;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotSearchBlock;
import buildcraft.robots.ai.AIRobotUseToolOnBlock;
import buildcraft.robots.boards.BoardRobotFarmerNBT;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BoardRobotFarmer
extends RedstoneBoardRobot {
    private BlockIndex blockFound;

    public BoardRobotFarmer(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotFarmerNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.getHeldItem() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack != null && stack.getItem() instanceof ItemHoe;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchBlock(this.robot, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return BuildCraftAPI.isDirtProperty.get(world, x, y, z) && !BoardRobotFarmer.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotFarmer.this.isAirAbove(world, x, y, z);
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.releaseBlockFound();
                AIRobotSearchBlock searchAI = (AIRobotSearchBlock)ai;
                if (searchAI.takeResource()) {
                    this.blockFound = searchAI.blockFound;
                    this.startDelegateAI(new AIRobotGotoBlock(this.robot, searchAI.path));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
        } else if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (this.robot.getHeldItem() == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotUseToolOnBlock) {
            this.releaseBlockFound();
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    @Override
    public void end() {
        this.releaseBlockFound();
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockFound")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("blockFound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, int x, int y, int z) {
        World world2 = world;
        synchronized (world2) {
            return world.isAirBlock(x, y + 1, z);
        }
    }
}

