/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.utils.IEntityFilter;
import buildcraft.robots.ai.AIRobotAttack;
import buildcraft.robots.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotSearchEntity;
import buildcraft.robots.boards.BoardRobotKnightNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public class BoardRobotKnight
extends RedstoneBoardRobot {
    public BoardRobotKnight(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotKnightNBT.instance;
    }

    @Override
    public final void update() {
        if (this.robot.getHeldItem() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack.getItem() instanceof ItemSword;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchEntity(this.robot, new IEntityFilter(){

                @Override
                public boolean matches(Entity entity) {
                    return entity instanceof IMob || entity instanceof EntityWolf && ((EntityWolf)entity).isAngry();
                }
            }, 250.0f, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (this.robot.getHeldItem() == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchEntity) {
            AIRobotSearchEntity mobAI = (AIRobotSearchEntity)ai;
            if (mobAI.target != null) {
                this.startDelegateAI(new AIRobotAttack(this.robot, ((AIRobotSearchEntity)ai).target));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }
}

