/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robots.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robots.boards.BoardRobotGenericBreakBlock;
import buildcraft.robots.boards.BoardRobotMinerNBT;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BoardRobotMiner
extends BoardRobotGenericBreakBlock {
    private int harvestLevel = 0;

    public BoardRobotMiner(EntityRobotBase iRobot) {
        super(iRobot);
        this.detectHarvestLevel();
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        super.delegateAIEnded(ai);
        if (ai instanceof AIRobotFetchAndEquipItemStack) {
            this.detectHarvestLevel();
        }
    }

    private void detectHarvestLevel() {
        ItemStack stack = this.robot.getHeldItem();
        if (stack != null && stack.getItem() instanceof ItemPickaxe) {
            ItemPickaxe pickaxe = (ItemPickaxe)stack.getItem();
            this.harvestLevel = pickaxe.getHarvestLevel(stack, "pickaxe");
        }
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotMinerNBT.instance;
    }

    @Override
    public boolean isExpectedTool(ItemStack stack) {
        return stack != null && stack.getItem() instanceof ItemPickaxe;
    }

    @Override
    public boolean isExpectedBlock(World world, int x, int y, int z) {
        return BuildCraftAPI.isOreProperty[Math.min(BuildCraftAPI.isOreProperty.length, this.harvestLevel)].get(world, x, y, z);
    }
}

