/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.ArrayStackOrListFilter;
import buildcraft.core.inventory.filters.CompositeFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.utils.IBlockFilter;
import buildcraft.robots.ResourceIdBlock;
import buildcraft.robots.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robots.ai.AIRobotGotoBlock;
import buildcraft.robots.ai.AIRobotGotoSleep;
import buildcraft.robots.ai.AIRobotSearchRandomBlock;
import buildcraft.robots.ai.AIRobotUseToolOnBlock;
import buildcraft.robots.boards.BoardRobotPlanterNBT;
import buildcraft.robots.statements.ActionRobotFilter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BoardRobotPlanter
extends RedstoneBoardRobot {
    private IStackFilter stackFilter = new CompositeFilter(new PlantableFilter(), new ReedFilter());
    private BlockIndex blockFound;

    public BoardRobotPlanter(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotPlanterNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.getHeldItem() == null) {
            Collection<ItemStack> gateFilter = ActionRobotFilter.getGateFilterStacks(this.robot.getLinkedStation());
            if (gateFilter.size() != 0) {
                ArrayList<ItemStack> filteredFilter = new ArrayList<ItemStack>();
                for (ItemStack tentative : gateFilter) {
                    if (!this.stackFilter.matches(tentative)) continue;
                    filteredFilter.add(tentative);
                }
                if (filteredFilter.size() > 0) {
                    ArrayStackOrListFilter arrayFilter = new ArrayStackOrListFilter(filteredFilter.toArray(new ItemStack[filteredFilter.size()]));
                    this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, arrayFilter));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
            } else {
                this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, this.stackFilter));
            }
        } else {
            IBlockFilter blockFilter;
            final ItemStack itemStack = this.robot.getHeldItem();
            if (itemStack.getItem() instanceof ItemReed) {
                blockFilter = new IBlockFilter(){

                    @Override
                    public boolean matches(World world, int x, int y, int z) {
                        return BoardRobotPlanter.this.isPlantable((IPlantable)Blocks.reeds, Blocks.reeds, world, x, y, z) && !BoardRobotPlanter.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotPlanter.this.isAirAbove(world, x, y, z);
                    }
                };
            } else if (itemStack.getItem() instanceof ItemBlock) {
                final Block plantBlock = ((ItemBlock)itemStack.getItem()).field_150939_a;
                blockFilter = new IBlockFilter(){

                    @Override
                    public boolean matches(World world, int x, int y, int z) {
                        return BoardRobotPlanter.this.isPlantable((IPlantable)plantBlock, plantBlock, world, x, y, z) && !BoardRobotPlanter.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotPlanter.this.isAirAbove(world, x, y, z);
                    }
                };
            } else {
                blockFilter = new IBlockFilter(){

                    @Override
                    public boolean matches(World world, int x, int y, int z) {
                        return BoardRobotPlanter.this.isPlantable((IPlantable)itemStack.getItem(), null, world, x, y, z) && !BoardRobotPlanter.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotPlanter.this.isAirAbove(world, x, y, z);
                    }
                };
            }
            this.startDelegateAI(new AIRobotSearchRandomBlock(this.robot, blockFilter));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchRandomBlock) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.releaseBlockFound();
                AIRobotSearchRandomBlock searchAI = (AIRobotSearchRandomBlock)ai;
                if (searchAI.takeResource()) {
                    this.blockFound = searchAI.blockFound;
                    if (searchAI.path.size() > 1) {
                        searchAI.path.removeLast();
                    }
                    this.startDelegateAI(new AIRobotGotoBlock(this.robot, searchAI.path));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
        } else if (ai instanceof AIRobotUseToolOnBlock) {
            this.releaseBlockFound();
        } else if (ai instanceof AIRobotFetchAndEquipItemStack && this.robot.getHeldItem() == null) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPlantable(IPlantable plant, Block block, World world, int x, int y, int z) {
        World world2 = world;
        synchronized (world2) {
            return world.getBlock(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, plant) && (block == null || world.getBlock(x, y, z) != block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, int x, int y, int z) {
        World world2 = world;
        synchronized (world2) {
            return world.isAirBlock(x, y + 1, z);
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockFound")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("blockFound"));
        }
    }

    private static class ReedFilter
    implements IStackFilter {
        private ReedFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return stack.getItem() instanceof ItemReed;
        }
    }

    private static class PlantableFilter
    implements IStackFilter {
        private PlantableFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack.getItem() instanceof IPlantable) {
                return true;
            }
            return stack.getItem() instanceof ItemBlock && ((ItemBlock)stack.getItem()).field_150939_a instanceof IPlantable;
        }
    }
}

