/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.statements;

import buildcraft.api.robots.IDockingStation;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.inventory.filters.ArrayStackOrListFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.inventory.filters.PassThroughStackFilter;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.robots.DockingStation;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;

public class ActionRobotFilterTool
extends BCStatement
implements IActionInternal {
    public ActionRobotFilterTool() {
        super("buildcraft:robot.work_filter_tool");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.robot.filter_tool");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/action_robot_filter_tool");
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static Collection<ItemStack> getGateFilterStacks(IDockingStation station) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (StatementSlot slot : new ActionIterator(((DockingStation)station).getPipe().pipe)) {
            if (!(slot.statement instanceof ActionRobotFilterTool)) continue;
            for (IStatementParameter p : slot.parameters) {
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null) continue;
                result.add(stack);
            }
        }
        return result;
    }

    public static IStackFilter getGateFilter(IDockingStation station) {
        Collection<ItemStack> stacks = ActionRobotFilterTool.getGateFilterStacks(station);
        if (stacks.size() == 0) {
            return new PassThroughStackFilter();
        }
        return new ArrayStackOrListFilter(stacks.toArray(new ItemStack[stacks.size()]));
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
    }
}

