/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.statements;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.RobotRegistry;
import buildcraft.robots.RobotUtils;
import buildcraft.robots.ai.AIRobotGoAndLinkToDock;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionRobotGotoStation
extends BCStatement
implements IActionInternal {
    public ActionRobotGotoStation() {
        super("buildcraft:robot.goto_station");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.robot.goto_station");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/action_robot_goto_station");
    }

    @Override
    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container.getTile() instanceof IPipeTile)) {
            return;
        }
        IPipeTile tile = (IPipeTile)container.getTile();
        RobotRegistry registry = RobotRegistry.getRegistry(tile.getWorld());
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            ForgeDirection side;
            DockingStation paramStation;
            IMapLocation map;
            BlockIndex index;
            StatementParameterItemStack stackParam;
            ItemStack item;
            EntityRobot robot;
            AIRobot ai;
            DockingStation station = RobotUtils.getStation(tile, d);
            if (station == null || station.robotTaking() == null || (ai = (robot = (EntityRobot)station.robotTaking()).getOverridingAI()) != null) continue;
            DockingStation newStation = station;
            if (parameters[0] != null && (item = (stackParam = (StatementParameterItemStack)parameters[0]).getItemStack()) != null && item.getItem() instanceof IMapLocation && (index = (map = (IMapLocation)item.getItem()).getPoint(item)) != null && (paramStation = (DockingStation)registry.getStation(index.x, index.y, index.z, side = map.getPointSide(item))) != null) {
                newStation = paramStation;
            }
            robot.overrideAI(new AIRobotGoAndLinkToDock(robot, newStation));
        }
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }
}

