/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.statements;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.StringUtils;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.statements.ActionStationInputItems;
import buildcraft.transport.gates.StatementSlot;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionStationAcceptItemsInv
extends ActionStationInputItems {
    public ActionStationAcceptItemsInv() {
        super("buildcraft:station.accept_items");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.station.accept_items");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/action_station_accept_items");
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public boolean insert(DockingStation station, EntityRobot robot, StatementSlot actionSlot, IInvSlot invSlot, boolean doInsert) {
        if (!super.insert(station, robot, actionSlot, invSlot, doInsert)) {
            return false;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity nearbyTile = robot.worldObj.getTileEntity(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
            if (nearbyTile == null || !(nearbyTile instanceof IInventory)) continue;
            ITransactor trans = Transactor.getTransactorFor(nearbyTile);
            ItemStack added = trans.add(invSlot.getStackInSlot(), dir.getOpposite(), doInsert);
            if (doInsert) {
                invSlot.decreaseStackInSlot(added.stackSize);
            }
            return true;
        }
        return false;
    }
}

