/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.statements;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.utils.StringUtils;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.statements.ActionStationInputItems;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.StatementSlot;
import net.minecraft.client.renderer.texture.IIconRegister;

public class ActionStationAcceptItemsPipe
extends ActionStationInputItems {
    public ActionStationAcceptItemsPipe() {
        super("buildcraft:station.drop_in_pipe");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.station.drop_items_in_pipe");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/action_station_drop_in_pipe");
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public boolean insert(DockingStation station, EntityRobot robot, StatementSlot actionSlot, IInvSlot invSlot, boolean doInsert) {
        if (!super.insert(station, robot, actionSlot, invSlot, doInsert)) {
            return false;
        }
        if (!doInsert) {
            return true;
        }
        if (station.getPipe().pipe.transport instanceof PipeTransportItems) {
            float cx = (float)station.x() + 0.5f + 0.2f * (float)station.side().offsetX;
            float cy = (float)station.y() + 0.5f + 0.2f * (float)station.side().offsetY;
            float cz = (float)station.z() + 0.5f + 0.2f * (float)station.side().offsetZ;
            TravelingItem item = TravelingItem.make(cx, cy, cz, invSlot.getStackInSlot());
            ((PipeTransportItems)station.getPipe().pipe.transport).injectItem(item, station.side().getOpposite());
            invSlot.setStackInSlot(null);
            return true;
        }
        return false;
    }
}

