/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.RobotUtils;
import buildcraft.robots.ai.AIRobotSleep;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerRobotSleep
extends BCStatement
implements ITriggerInternal {
    public TriggerRobotSleep() {
        super("buildcraft:robot.sleep");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.robot.sleep");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/trigger_robot_sleep");
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container.getTile() instanceof IPipeTile)) {
            return false;
        }
        IPipeTile tile = (IPipeTile)container.getTile();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            DockingStation station = RobotUtils.getStation(tile, d);
            if (station == null || station.robotTaking() == null) continue;
            EntityRobot robot = (EntityRobot)station.robotTaking();
            if (!(robot.mainAI.getActiveAI() instanceof AIRobotSleep)) continue;
            return true;
        }
        return false;
    }
}

