/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileChargingTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileProgrammingTable;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockLaserTable
extends BlockBuildCraft
implements ILaserTargetBlock {
    protected static final int TABLE_MAX = 5;
    private static final String[] ICON_NAMES = new String[]{"assemblytable", "advworkbenchtable", "integrationtable", "chargingtable", "programmingtable"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public BlockLaserTable() {
        super(Material.iron);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
        this.setHardness(10.0f);
        this.setCreativeTab(CreativeTabBuildCraft.BLOCKS.get());
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.isSneaking()) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this, world.getBlockMetadata(i, j, k));
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (!world.isRemote) {
            int meta = world.getBlockMetadata(i, j, k);
            entityplayer.openGui((Object)BuildCraftSilicon.instance, meta, world, i, j, k);
        }
        return true;
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.breakBlock(world, x, y, z, block, par6);
    }

    public IIcon getIcon(int side, int meta) {
        if (meta >= 5) {
            return null;
        }
        int s = side > 1 ? 2 : side;
        return this.icons[meta][s];
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileAssemblyTable();
            }
            case 1: {
                return new TileAdvancedCraftingTable();
            }
            case 2: {
                return new TileIntegrationTable();
            }
            case 3: {
                return new TileChargingTable();
            }
            case 4: {
                return new TileProgrammingTable();
            }
        }
        return null;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return null;
    }

    public int damageDropped(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 5; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.icons = new IIcon[5][];
        for (int i = 0; i < 5; ++i) {
            this.icons[i] = new IIcon[3];
            this.icons[i][0] = par1IconRegister.registerIcon("buildcraft:" + ICON_NAMES[i] + "_bottom");
            this.icons[i][1] = par1IconRegister.registerIcon("buildcraft:" + ICON_NAMES[i] + "_top");
            this.icons[i][2] = par1IconRegister.registerIcon("buildcraft:" + ICON_NAMES[i] + "_side");
        }
    }
}

