/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.utils.NBTUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemRedstoneBoard
extends ItemBuildCraft {
    public IIcon cleanBoard;
    public IIcon unknownBoard;

    public ItemRedstoneBoard() {
        super(CreativeTabBuildCraft.BOARDS);
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).hasKey("id") ? 1 : 16;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (cpt.hasKey("id") && !"<unknown>".equals(cpt.getString("id"))) {
            RedstoneBoardRegistry.instance.getRedstoneBoard(cpt).addInformation(stack, player, list, advanced);
        }
    }

    public IIcon getIconIndex(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        this.itemIcon = !cpt.hasKey("id") ? this.cleanBoard : ("<unknown>".equals(cpt.getString("id")) ? this.unknownBoard : RedstoneBoardRegistry.instance.getRedstoneBoard(cpt).getIcon(cpt));
        return this.itemIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.cleanBoard = par1IconRegister.registerIcon("buildcraft:board_clean");
        this.unknownBoard = par1IconRegister.registerIcon("buildcraft:board_unknown");
        RedstoneBoardRegistry.instance.registerIcons(par1IconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (RedstoneBoardNBT<?> nbt : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            ItemStack stack = new ItemStack((Item)BuildCraftSilicon.redstoneBoard);
            NBTTagCompound nbtData = NBTUtils.getItemData(stack);
            nbt.createBoard(nbtData);
            itemList.add(stack.copy());
        }
    }

    public static boolean isClean(ItemStack stack) {
        return !stack.hasTagCompound() || !stack.getTagCompound().hasKey("id");
    }
}

