/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.core.ItemBuildCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemRedstoneChipset
extends ItemBuildCraft {
    public ItemRedstoneChipset() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public IIcon getIconFromDamage(int damage) {
        return Chipset.fromOrdinal(damage).icon;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "item." + Chipset.fromOrdinal(stack.getItemDamage()).getChipsetName();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        for (Chipset chipset : Chipset.VALUES) {
            itemList.add(chipset.getStack());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        for (Chipset chipset : Chipset.VALUES) {
            chipset.icon = par1IconRegister.registerIcon("buildcraft:" + chipset.getChipsetName());
        }
    }

    public void registerItemStacks() {
        for (Chipset chipset : Chipset.VALUES) {
            GameRegistry.registerCustomItemStack((String)chipset.getChipsetName(), (ItemStack)chipset.getStack());
        }
    }

    public static enum Chipset {
        RED,
        IRON,
        GOLD,
        DIAMOND,
        PULSATING,
        QUARTZ,
        COMP,
        EMERALD;

        public static final Chipset[] VALUES;
        private IIcon icon;

        public String getChipsetName() {
            return "redstone_" + this.name().toLowerCase(Locale.ENGLISH) + "_chipset";
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int qty) {
            return new ItemStack((Item)BuildCraftSilicon.redstoneChipset, qty, this.ordinal());
        }

        public static Chipset fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return RED;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = Chipset.values();
        }
    }
}

