/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.ResourceIdAssemblyTable;
import buildcraft.robots.RobotRegistry;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileAssemblyTable
extends TileLaserTableBase
implements IInventory,
IFlexibleCrafter,
ICommandReceiver {
    public String currentRecipeId = "";
    public IFlexibleRecipe<ItemStack> currentRecipe;
    private HashSet<String> plannedOutput = new HashSet();
    private boolean queuedNetworkUpdate = false;

    public List<CraftingResult<ItemStack>> getPotentialOutputs() {
        LinkedList<CraftingResult<ItemStack>> result = new LinkedList<CraftingResult<ItemStack>>();
        for (IFlexibleRecipe<ItemStack> recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            CraftingResult<ItemStack> r = recipe.craft(this, true);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    private void queueNetworkUpdate() {
        this.queuedNetworkUpdate = true;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.queuedNetworkUpdate) {
            this.sendNetworkUpdate();
            this.queuedNetworkUpdate = false;
        }
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeCrafted(this)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.getEnergy() >= this.currentRecipe.craft((IFlexibleCrafter)this, (boolean)true).energyCost) {
            this.setEnergy(0);
            if (this.currentRecipe.canBeCrafted(this)) {
                ItemStack remaining = ((ItemStack)this.currentRecipe.craft((IFlexibleCrafter)this, (boolean)false).crafted).copy();
                EntityRobot robot = RobotRegistry.getRegistry(this.worldObj).robotTaking(new ResourceIdAssemblyTable(this));
                if (robot != null) {
                    remaining = robot.receiveItem(this, remaining);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    remaining.stackSize -= Utils.addToRandomInventoryAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, remaining);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    remaining.stackSize -= Utils.addToRandomInjectableAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.7, (double)this.zCoord + 0.5, remaining);
                    this.worldObj.spawnEntityInWorld((Entity)entityitem);
                }
                this.setNextCurrentRecipe();
            }
        }
    }

    public int getSizeInventory() {
        return 12;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.assemblyTableBlock.name");
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.currentRecipeId = Utils.readUTF(stream);
        this.plannedOutput.clear();
        int size = stream.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            this.plannedOutput.add(Utils.readUTF(stream));
        }
        this.currentRecipe = AssemblyRecipeManager.INSTANCE.getRecipe(this.currentRecipeId);
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        Utils.writeUTF(stream, this.currentRecipeId);
        stream.writeByte(this.plannedOutput.size());
        for (String s : this.plannedOutput) {
            Utils.writeUTF(stream, s);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        IFlexibleRecipe recipe;
        super.readFromNBT(nbt);
        NBTTagList list = nbt.getTagList("plannedIds", 8);
        for (int i = 0; i < list.tagCount(); ++i) {
            IFlexibleRecipe recipe2 = AssemblyRecipeManager.INSTANCE.getRecipe(list.getStringTagAt(i));
            if (recipe2 == null) continue;
            this.plannedOutput.add(recipe2.getId());
        }
        if (nbt.hasKey("recipeId") && (recipe = AssemblyRecipeManager.INSTANCE.getRecipe(nbt.getString("recipeId"))) != null) {
            this.setCurrentRecipe(recipe);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList list = new NBTTagList();
        for (String recipe : this.plannedOutput) {
            list.appendTag((NBTBase)new NBTTagString(recipe));
        }
        nbt.setTag("plannedIds", (NBTBase)list);
        if (this.currentRecipe != null) {
            nbt.setString("recipeId", this.currentRecipe.getId());
        }
    }

    public boolean isPlanned(IFlexibleRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return this.plannedOutput.contains(recipe.getId());
    }

    public boolean isAssembling(IFlexibleRecipe recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.currentRecipe = recipe;
        this.currentRecipeId = recipe != null ? recipe.getId() : "";
        if (this.worldObj != null && !this.worldObj.isRemote) {
            this.queueNetworkUpdate();
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (this.currentRecipe != null) {
            CraftingResult<ItemStack> result = this.currentRecipe.craft(this, true);
            if (result != null) {
                return result.energyCost;
            }
            return 0;
        }
        return 0;
    }

    public void planOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe.getId());
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
            this.queueNetworkUpdate();
        }
    }

    public void cancelPlanOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe.getId());
        if (!this.plannedOutput.isEmpty()) {
            this.setCurrentRecipe(AssemblyRecipeManager.INSTANCE.getRecipe(this.plannedOutput.iterator().next()));
        }
        this.queueNetworkUpdate();
    }

    public void setNextCurrentRecipe() {
        IFlexibleRecipe recipe;
        boolean takeNext = false;
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (recipe == null) continue;
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (recipe == null || !recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    public void rpcSelectRecipe(final String id, final boolean select) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "select", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                Utils.writeUTF(data, id);
                data.writeBoolean(select);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "select".equals(command)) {
            String id = Utils.readUTF(stream);
            boolean select = stream.readBoolean();
            IFlexibleRecipe recipe = AssemblyRecipeManager.INSTANCE.getRecipe(id);
            if (recipe != null) {
                if (select) {
                    this.planOutput(recipe);
                } else {
                    this.cancelPlanOutput(recipe);
                }
            }
        }
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.getSizeInventory();
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.getStackInSlot(slotid);
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return this.decrStackSize(slotid, val);
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return null;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        return null;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return 0;
    }
}

