/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileIntegrationTable
extends TileLaserTableBase
implements IFlexibleCrafter {
    public static final int SLOT_INPUT_A = 0;
    public static final int SLOT_INPUT_B = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int CYCLE_LENGTH = 32;
    private int tick = 0;
    private SimpleInventory invRecipeOutput = new SimpleInventory(1, "integrationOutput", 64);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1, false);
    private IFlexibleRecipe<ItemStack> activeRecipe;
    private CraftingResult<ItemStack> craftingPreview;

    public IInventory getRecipeOutput() {
        return this.invRecipeOutput;
    }

    private ItemStack[] getComponents() {
        ItemStack[] components = new ItemStack[9];
        for (int i = 3; i < 12; ++i) {
            components[i - 2 - 1] = this.inv.getStackInSlot(i);
        }
        return components;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateRecipe();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.activeRecipe == null || this.craftingPreview == null) {
            this.setEnergy(0);
            return;
        }
        ++this.tick;
        if (this.tick % 32 != 0) {
            return;
        }
        if (!this.isRoomForOutput((ItemStack)this.craftingPreview.crafted)) {
            this.setEnergy(0);
            return;
        }
        if (this.getEnergy() >= this.craftingPreview.energyCost) {
            this.setEnergy(0);
            this.craftingPreview = null;
            CraftingResult<ItemStack> craftResult = this.activeRecipe.craft(this, false);
            if (craftResult != null) {
                ItemStack result = ((ItemStack)craftResult.crafted).copy();
                ITransactor trans = Transactor.getTransactorFor(this.invOutput);
                trans.add(result, ForgeDirection.UP, true);
            }
        }
    }

    private void setNewActiveRecipe(ItemStack inputA, ItemStack inputB, ItemStack[] components) {
        this.craftingPreview = null;
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(inputA) || !iIntegrationRecipe.isValidInputB(inputB)) continue;
            this.craftingPreview = iIntegrationRecipe.craft(this, true);
            if (this.craftingPreview == null) continue;
            this.activeRecipe = iIntegrationRecipe;
            break;
        }
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.getStackInSlot(2);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.canStacksMerge(output, existingOutput) && output.stackSize + existingOutput.stackSize <= output.getMaxStackSize();
    }

    @Override
    public int getRequiredEnergy() {
        if (this.craftingPreview != null) {
            return this.craftingPreview.energyCost;
        }
        return 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return this.isValidInputA(stack);
            }
            case 1: {
                return this.isValidInputB(stack);
            }
        }
        return false;
    }

    private boolean isValidInputA(ItemStack stack) {
        ItemStack inputB = this.inv.getStackInSlot(1);
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(stack) || inputB != null && !iIntegrationRecipe.isValidInputB(inputB)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidInputB(ItemStack stack) {
        ItemStack inputA = this.inv.getStackInSlot(0);
        for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputB(stack) || inputA != null && !iIntegrationRecipe.isValidInputA(inputA)) continue;
            return true;
        }
        return false;
    }

    public int getSizeInventory() {
        return 12;
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.craftingPreview != null;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        this.updateRecipe();
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack result = super.decrStackSize(slot, amount);
        this.updateRecipe();
        return result;
    }

    private void updateRecipe() {
        ItemStack inputA = this.inv.getStackInSlot(0);
        ItemStack inputB = this.inv.getStackInSlot(1);
        ItemStack[] components = this.getComponents();
        this.setNewActiveRecipe(inputA, inputB, components);
        if (this.craftingPreview != null) {
            this.invRecipeOutput.setInventorySlotContents(0, (ItemStack)this.craftingPreview.crafted);
        } else {
            this.invRecipeOutput.setInventorySlotContents(0, null);
        }
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.getSizeInventory() - 3;
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.getStackInSlot(slotid + 3);
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return this.decrStackSize(slotid + 3, val);
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return null;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        return null;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return 0;
    }
}

