/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.ILaserTarget;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.Box;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLaser
extends TileBuildCraft
implements IHasWork,
IControllable {
    private static final float LASER_OFFSET = 0.125f;
    private static final short POWER_AVERAGING = 100;
    public LaserData laser = new LaserData();
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker(10L);
    private final SafeTimeTracker searchTracker = new SafeTimeTracker(100L, 100L);
    private final SafeTimeTracker networkTracker = new SafeTimeTracker(20L, 3L);
    private ILaserTarget laserTarget;
    private int powerIndex = 0;
    private short powerAverage = 0;
    private final short[] power = new short[100];

    public TileLaser() {
        this.setBattery(new RFBattery(10000, 250, 0));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.laser == null) {
            this.laser = new LaserData();
        }
        this.laser.isVisible = false;
        this.laser.head = new Position(this.xCoord, this.yCoord, this.zCoord);
        this.laser.tail = new Position(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.laser.iterateTexture();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            this.removeLaser();
            return;
        }
        if (this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            this.removeLaser();
            return;
        }
        this.laser.isVisible = true;
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        int localPower = this.getBattery().useEnergy(0, this.getMaxPowerSent(), false);
        this.laserTarget.receiveLaserEnergy(localPower);
        if (this.laser != null) {
            this.pushPower(localPower);
        }
        this.onPowerSent(localPower);
        this.sendNetworkUpdate();
    }

    protected int getMaxPowerSent() {
        return 40;
    }

    protected void onPowerSent(int power) {
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.worldObj);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.worldObj);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.isInvalidTarget() && this.laserTarget.requiresLaserEnergy();
    }

    protected void findTable() {
        int meta = this.getBlockMetadata();
        int minX = this.xCoord - 5;
        int minY = this.yCoord - 5;
        int minZ = this.zCoord - 5;
        int maxX = this.xCoord + 5;
        int maxY = this.yCoord + 5;
        int maxZ = this.zCoord + 5;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                maxX = this.xCoord;
                break;
            }
            case EAST: {
                minX = this.xCoord;
                break;
            }
            case DOWN: {
                maxY = this.yCoord;
                break;
            }
            case UP: {
                minY = this.yCoord;
                break;
            }
            case NORTH: {
                maxZ = this.zCoord;
                break;
            }
            default: {
                minZ = this.zCoord;
            }
        }
        LinkedList<ILaserTarget> targets = new LinkedList<ILaserTarget>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ILaserTarget table;
                    TileEntity tile;
                    if (!(this.worldObj.getBlock(x, y, z) instanceof ILaserTargetBlock) || !((tile = this.worldObj.getTileEntity(x, y, z)) instanceof ILaserTarget) || !(table = (ILaserTarget)tile).requiresLaserEnergy()) continue;
                    targets.add(table);
                }
            }
        }
        if (targets.isEmpty()) {
            return;
        }
        this.laserTarget = (ILaserTarget)targets.get(this.worldObj.rand.nextInt(targets.size()));
    }

    protected void updateLaser() {
        int meta = this.getBlockMetadata();
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                px = -0.125;
                break;
            }
            case EAST: {
                px = 0.125;
                break;
            }
            case DOWN: {
                py = -0.125;
                break;
            }
            case UP: {
                py = 0.125;
                break;
            }
            case NORTH: {
                pz = -0.125;
                break;
            }
            default: {
                pz = 0.125;
            }
        }
        Position head = new Position((double)this.xCoord + 0.5 + px, (double)this.yCoord + 0.5 + py, (double)this.zCoord + 0.5 + pz);
        Position tail = new Position(this.laserTarget.getXCoord() + 0.475 + ((double)this.worldObj.rand.nextFloat() - 0.5) / 5.0, this.laserTarget.getYCoord() + 0.5625, this.laserTarget.getZCoord() + 0.475 + ((double)this.worldObj.rand.nextFloat() - 0.5) / 5.0);
        this.laser.head = head;
        this.laser.tail = tail;
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
        }
    }

    protected void removeLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.worldObj)) {
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.laser = new LaserData();
        this.laser.readData(stream);
        this.powerAverage = stream.readShort();
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.laser.writeData(stream);
        stream.writeShort((int)this.powerAverage);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.removeLaser();
    }

    @Override
    public boolean hasWork() {
        return this.isValidTable();
    }

    private void pushPower(int received) {
        this.powerAverage = (short)(this.powerAverage - this.power[this.powerIndex]);
        this.powerAverage = (short)(this.powerAverage + received);
        this.power[this.powerIndex] = (short)received;
        ++this.powerIndex;
        if (this.powerIndex == this.power.length) {
            this.powerIndex = 0;
        }
    }

    public ResourceLocation getTexture() {
        double avg = this.powerAverage / 100;
        if (avg <= 10.0) {
            return EntityLaser.LASER_TEXTURES[0];
        }
        if (avg <= 20.0) {
            return EntityLaser.LASER_TEXTURES[1];
        }
        if (avg <= 30.0) {
            return EntityLaser.LASER_TEXTURES[2];
        }
        return EntityLaser.LASER_TEXTURES[3];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.laser.tail).getBoundingBox();
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off;
    }
}

