/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileProgrammingTable
extends TileLaserTableBase
implements IInventory,
ISidedInventory,
ICommandReceiver {
    public static final int WIDTH = 6;
    public static final int HEIGHT = 4;
    public String currentRecipeId = "";
    public IProgrammingRecipe currentRecipe;
    public List<ItemStack> options;
    public int optionId;
    private boolean queuedNetworkUpdate = false;

    private void queueNetworkUpdate() {
        this.queuedNetworkUpdate = true;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.queuedNetworkUpdate) {
            this.sendNetworkUpdate();
            this.queuedNetworkUpdate = false;
        }
        if (this.currentRecipe == null) {
            return;
        }
        if (this.getStackInSlot(0) == null || !this.currentRecipe.canCraft(this.getStackInSlot(0))) {
            this.findRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.optionId >= 0 && this.getStackInSlot(1) == null && this.getEnergy() >= this.currentRecipe.getEnergyCost(this.options.get(this.optionId))) {
            this.setEnergy(0);
            if (this.currentRecipe.canCraft(this.getStackInSlot(0))) {
                ItemStack remaining = this.currentRecipe.craft(this.getStackInSlot(0), this.options.get(this.optionId));
                this.decrStackSize(0, remaining.stackSize);
                if (remaining != null && remaining.stackSize > 0) {
                    remaining.stackSize -= Utils.addToRandomInventoryAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, remaining);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    remaining.stackSize -= Utils.addToRandomInjectableAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.7, (double)this.zCoord + 0.5, remaining);
                    this.worldObj.spawnEntityInWorld((Entity)entityitem);
                }
                if (remaining != null && remaining.stackSize > 0) {
                    this.setInventorySlotContents(1, remaining);
                }
                this.findRecipe();
            }
        }
    }

    public int getSizeInventory() {
        return 2;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        if (slot == 0) {
            this.findRecipe();
        }
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.programmingTableBlock.name");
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.currentRecipeId = Utils.readUTF(stream);
        this.optionId = stream.readUnsignedByte();
        this.updateRecipe();
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        Utils.writeUTF(stream, this.currentRecipeId);
        stream.writeByte(this.optionId);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.hasKey("recipeId") && nbt.hasKey("optionId")) {
            this.currentRecipeId = nbt.getString("recipeId");
            this.optionId = nbt.getInteger("optionId");
        } else {
            this.currentRecipeId = null;
        }
        this.updateRecipe();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.currentRecipeId != null) {
            nbt.setString("recipeId", this.currentRecipeId);
            nbt.setByte("optionId", (byte)this.optionId);
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (this.hasWork()) {
            return this.currentRecipe.getEnergyCost(this.options.get(this.optionId));
        }
        return 0;
    }

    public void findRecipe() {
        String oldId = this.currentRecipeId;
        this.currentRecipeId = null;
        if (this.getStackInSlot(0) != null) {
            for (IProgrammingRecipe recipe : BuildcraftRecipeRegistry.programmingTable.getRecipes()) {
                if (!recipe.canCraft(this.getStackInSlot(0))) continue;
                this.currentRecipeId = recipe.getId();
            }
        }
        if (oldId != null && !oldId.equals(this.currentRecipeId) || oldId == null && this.currentRecipeId != null) {
            this.optionId = -1;
            this.updateRecipe();
            this.queueNetworkUpdate();
        }
    }

    public void updateRecipe() {
        this.currentRecipe = BuildcraftRecipeRegistry.programmingTable.getRecipe(this.currentRecipeId);
        this.options = this.currentRecipe != null ? this.currentRecipe.getOptions(6, 4) : null;
    }

    public void rpcSelectOption(final int pos) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "select", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(pos);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "select".equals(command)) {
            this.optionId = stream.readUnsignedByte();
            if (this.optionId >= this.options.size()) {
                this.optionId = 0;
            }
            this.queueNetworkUpdate();
        }
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.optionId >= 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot == 0 || stack == null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[]{0, 1};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1;
    }
}

