/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.boards;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.core.utils.NBTUtils;
import buildcraft.silicon.ItemRedstoneBoard;
import buildcraft.silicon.boards.ImplRedstoneBoardRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BoardProgrammingRecipe
implements IProgrammingRecipe {
    @Override
    public String getId() {
        return "buildcraft:redstone_board";
    }

    @Override
    public List<ItemStack> getOptions(int width, int height) {
        ArrayList<ItemStack> options = new ArrayList<ItemStack>(width * height);
        for (RedstoneBoardNBT<?> nbt : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            ItemStack stack = new ItemStack((Item)BuildCraftSilicon.redstoneBoard);
            nbt.createBoard(NBTUtils.getItemData(stack));
            options.add(stack);
        }
        Collections.sort(options, new BoardSorter(this));
        return options;
    }

    @Override
    public int getEnergyCost(ItemStack option) {
        ImplRedstoneBoardRegistry impl = (ImplRedstoneBoardRegistry)RedstoneBoardRegistry.instance;
        return Math.round(20.0f / impl.getProbability(option.getTagCompound().getString("id")) * 8000.0f);
    }

    @Override
    public boolean canCraft(ItemStack input) {
        return input.getItem() instanceof ItemRedstoneBoard;
    }

    @Override
    public ItemStack craft(ItemStack input, ItemStack option) {
        return option;
    }

    private class BoardSorter
    implements Comparator<ItemStack> {
        private BoardProgrammingRecipe recipe;

        public BoardSorter(BoardProgrammingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            return this.recipe.getEnergyCost(o1) - this.recipe.getEnergyCost(o2);
        }
    }
}

