/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotOutput;
import buildcraft.core.gui.slots.SlotUntouchable;
import buildcraft.core.gui.slots.SlotValidated;
import buildcraft.silicon.TileIntegrationTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerIntegrationTable
extends BuildCraftContainer {
    private TileIntegrationTable table;

    public ContainerIntegrationTable(InventoryPlayer playerInventory, TileIntegrationTable table) {
        super(table.getSizeInventory());
        this.table = table;
        this.addSlot(new SlotValidated(table, 0, 17, 28));
        this.addSlot(new SlotValidated(table, 1, 53, 28));
        this.addSlot(new SlotOutput(table, 2, 143, 44));
        this.addSlot(new SlotUntouchable(table.getRecipeOutput(), 0, 116, 44));
        for (int i = 3; i < 12; ++i) {
            this.addSlot(new Slot((IInventory)table, i, 8 + (i - 3) * 18, 69));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 91 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlotToContainer(new Slot((IInventory)playerInventory, x, 8 + x * 18, 149));
        }
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return this.table.isUseableByPlayer(var1);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            this.table.sendGUINetworkData(this, (ICrafting)this.crafters.get(i));
        }
    }

    public void updateProgressBar(int par1, int par2) {
        this.table.getGUINetworkData(par1, par2);
    }
}

