/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.core.DefaultProps;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.gui.ContainerIntegrationTable;
import buildcraft.silicon.gui.GuiLaserTable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiIntegrationTable
extends GuiLaserTable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/integration_table.png");
    private static final int FLASH_DELAY = 3;
    private final TileIntegrationTable integrationTable;
    private boolean flash;
    private int flashDelay;

    public GuiIntegrationTable(InventoryPlayer playerInventory, TileIntegrationTable table) {
        super(playerInventory, new ContainerIntegrationTable(playerInventory, table), table, TEXTURE);
        this.integrationTable = table;
        this.xSize = 176;
        this.ySize = 173;
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.flashDelay <= 0) {
            this.flashDelay = 3;
            this.flash = !this.flash;
        } else {
            --this.flashDelay;
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.drawLedgers(par1, par2);
        String title = this.table.getInventoryName();
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        if (this.integrationTable.getEnergy() > 0) {
            int progress = this.integrationTable.getProgressScaled(98);
            this.drawTexturedModalRect(this.guiLeft + 13, this.guiTop + 40, 0, this.flash ? 197 : 221, progress, 24);
        }
    }
}

