/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiLaserTable
extends GuiBuildCraft {
    protected final TileLaserTableBase table;

    public GuiLaserTable(InventoryPlayer playerInventory, BuildCraftContainer container, TileLaserTableBase table, ResourceLocation texture) {
        super(container, table, texture);
        this.table = table;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        String title = this.table.getInventoryName();
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    private class LaserTableLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public LaserTableLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiLaserTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiLaserTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiLaserTable.this.fontRendererObj.drawString(String.format("%d RF", GuiLaserTable.this.table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiLaserTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiLaserTable.this.fontRendererObj.drawString(String.format("%d RF", GuiLaserTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiLaserTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiLaserTable.this.fontRendererObj.drawString(String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiLaserTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

