/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandlerSilicon
extends SimpleChannelInboundHandler<BuildCraftPacket> {
    protected void channelRead0(ChannelHandlerContext ctx, BuildCraftPacket packet) {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 70: {
                    this.onAdvancedWorkbenchSet(player, (PacketSlotChange)packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private TileAssemblyTable getAssemblyTable(World world, int x, int y, int z) {
        if (!world.blockExists(x, y, z)) {
            return null;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileAssemblyTable)) {
            return null;
        }
        return (TileAssemblyTable)tile;
    }

    private TileAdvancedCraftingTable getAdvancedWorkbench(World world, int x, int y, int z) {
        if (!world.blockExists(x, y, z)) {
            return null;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileAdvancedCraftingTable)) {
            return null;
        }
        return (TileAdvancedCraftingTable)tile;
    }

    private void onAdvancedWorkbenchSet(EntityPlayer player, PacketSlotChange packet1) {
        TileAdvancedCraftingTable tile = this.getAdvancedWorkbench(player.worldObj, packet1.posX, packet1.posY, packet1.posZ);
        if (tile == null) {
            return;
        }
        tile.updateCraftingMatrix(packet1.slot, packet1.stack);
    }
}

