/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IGate;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionReceptor;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeWire;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.gates.StatementSlot;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.statements.ActionValve;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class Gate
implements IGate,
IStatementContainer {
    public static int MAX_STATEMENTS = 8;
    public static int MAX_PARAMETERS = 3;
    public final Pipe<?> pipe;
    public final GateDefinition.GateMaterial material;
    public final GateDefinition.GateLogic logic;
    public final BiMap<IGateExpansion, GateExpansionController> expansions = HashBiMap.create();
    public IStatement[] triggers = new IStatement[MAX_STATEMENTS];
    public IStatementParameter[][] triggerParameters = new IStatementParameter[MAX_STATEMENTS][MAX_PARAMETERS];
    public IStatement[] actions = new IStatement[MAX_STATEMENTS];
    public IStatementParameter[][] actionParameters = new IStatementParameter[MAX_STATEMENTS][MAX_PARAMETERS];
    public ActionActiveState[] actionsState = new ActionActiveState[MAX_STATEMENTS];
    public ArrayList<StatementSlot> activeActions = new ArrayList();
    public BitSet broadcastSignal = new BitSet(PipeWire.VALUES.length);
    public BitSet prevBroadcastSignal = new BitSet(PipeWire.VALUES.length);
    public int redstoneOutput = 0;
    public int redstoneOutputSide = 0;
    public boolean isPulsing = false;
    private float pulseStage = 0.0f;
    private ForgeDirection direction;
    private HashMultiset<IStatement> statementCounts = HashMultiset.create();

    public Gate(Pipe<?> pipe, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic, ForgeDirection direction) {
        this.pipe = pipe;
        this.material = material;
        this.logic = logic;
        this.direction = direction;
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = ActionActiveState.Deactivated;
        }
    }

    public void setTrigger(int position, IStatement trigger) {
        if (trigger != this.triggers[position]) {
            for (int i = 0; i < this.triggerParameters[position].length; ++i) {
                this.triggerParameters[position][i] = null;
            }
        }
        this.triggers[position] = trigger;
    }

    public IStatement getTrigger(int position) {
        return this.triggers[position];
    }

    public void setAction(int position, IStatement action) {
        if (this.actions[position] instanceof ActionValve && this.pipe != null && this.pipe.transport != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                ((PipeTransport)this.pipe.transport).allowInput(side, true);
                ((PipeTransport)this.pipe.transport).allowOutput(side, true);
            }
        }
        if (action != this.actions[position]) {
            for (int i = 0; i < this.actionParameters[position].length; ++i) {
                this.actionParameters[position][i] = null;
            }
        }
        this.actions[position] = action;
    }

    public IStatement getAction(int position) {
        return this.actions[position];
    }

    public void setTriggerParameter(int trigger, int param, IStatementParameter p) {
        this.triggerParameters[trigger][param] = p;
    }

    public void setActionParameter(int action, int param, IStatementParameter p) {
        this.actionParameters[action][param] = p;
    }

    public IStatementParameter getTriggerParameter(int trigger, int param) {
        return this.triggerParameters[trigger][param];
    }

    public IStatementParameter getActionParameter(int action, int param) {
        return this.actionParameters[action][param];
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public void setDirection(ForgeDirection direction) {
        this.direction = direction;
    }

    public void addGateExpansion(IGateExpansion expansion) {
        if (!this.expansions.containsKey((Object)expansion)) {
            this.expansions.put((Object)expansion, (Object)expansion.makeController(this.pipe != null ? this.pipe.container : null));
        }
    }

    public void writeStatementsToNBT(NBTTagCompound data) {
        for (int i = 0; i < this.material.numSlots; ++i) {
            NBTTagCompound cpt;
            int j;
            if (this.triggers[i] != null) {
                data.setString("trigger[" + i + "]", this.triggers[i].getUniqueTag());
            }
            if (this.actions[i] != null) {
                data.setString("action[" + i + "]", this.actions[i].getUniqueTag());
            }
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                if (this.triggerParameters[i][j] == null) continue;
                cpt = new NBTTagCompound();
                cpt.setString("kind", this.triggerParameters[i][j].getUniqueTag());
                this.triggerParameters[i][j].writeToNBT(cpt);
                data.setTag("triggerParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                if (this.actionParameters[i][j] == null) continue;
                cpt = new NBTTagCompound();
                cpt.setString("kind", this.actionParameters[i][j].getUniqueTag());
                this.actionParameters[i][j].writeToNBT(cpt);
                data.setTag("actionParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.setString("material", this.material.name());
        data.setString("logic", this.logic.name());
        data.setInteger("direction", this.direction.ordinal());
        NBTTagList exList = new NBTTagList();
        for (GateExpansionController con : this.expansions.values()) {
            NBTTagCompound conNBT = new NBTTagCompound();
            conNBT.setString("type", con.getType().getUniqueIdentifier());
            NBTTagCompound conData = new NBTTagCompound();
            con.writeToNBT(conData);
            conNBT.setTag("data", (NBTBase)conData);
            exList.appendTag((NBTBase)conNBT);
        }
        data.setTag("expansions", (NBTBase)exList);
        this.writeStatementsToNBT(data);
        for (PipeWire wire : PipeWire.VALUES) {
            data.setBoolean("wireState[" + wire.ordinal() + "]", this.broadcastSignal.get(wire.ordinal()));
        }
        data.setByte("redstoneOutput", (byte)this.redstoneOutput);
    }

    public void readStatementsFromNBT(NBTTagCompound data) {
        int j;
        int i;
        for (i = 0; i < this.material.numSlots; ++i) {
            this.triggers[i] = null;
            this.actions[i] = null;
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                this.triggerParameters[i][j] = null;
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                this.actionParameters[i][j] = null;
            }
        }
        for (i = 0; i < this.material.numSlots; ++i) {
            NBTTagCompound cpt;
            if (data.hasKey("trigger[" + i + "]")) {
                this.triggers[i] = StatementManager.statements.get(data.getString("trigger[" + i + "]"));
            }
            if (data.hasKey("action[" + i + "]")) {
                this.actions[i] = StatementManager.statements.get(data.getString("action[" + i + "]"));
            }
            if (data.hasKey("triggerParameters[" + i + "]")) {
                this.triggerParameters[i][0] = new StatementParameterItemStack();
                this.triggerParameters[i][0].readFromNBT(data.getCompoundTag("triggerParameters[" + i + "]"));
            }
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                if (!data.hasKey("triggerParameters[" + i + "][" + j + "]")) continue;
                cpt = data.getCompoundTag("triggerParameters[" + i + "][" + j + "]");
                this.triggerParameters[i][j] = StatementManager.createParameter(cpt.getString("kind"));
                this.triggerParameters[i][j].readFromNBT(cpt);
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                if (!data.hasKey("actionParameters[" + i + "][" + j + "]")) continue;
                cpt = data.getCompoundTag("actionParameters[" + i + "][" + j + "]");
                this.actionParameters[i][j] = StatementManager.createParameter(cpt.getString("kind"));
                this.actionParameters[i][j].readFromNBT(cpt);
            }
        }
    }

    public boolean verifyGateStatements() {
        List<IStatement> triggerList = this.getAllValidTriggers();
        List<IStatement> actionList = this.getAllValidActions();
        boolean warning = false;
        for (int i = 0; i < MAX_STATEMENTS; ++i) {
            if ((this.triggers[i] != null || this.actions[i] != null) && i >= this.material.numSlots) {
                this.triggers[i] = null;
                this.actions[i] = null;
                warning = true;
                continue;
            }
            if (!(this.triggers[i] == null || triggerList.contains(this.triggers[i]) && this.triggers[i].minParameters() <= this.material.numTriggerParameters)) {
                this.triggers[i] = null;
                warning = true;
            }
            if (this.actions[i] == null || actionList.contains(this.actions[i]) && this.actions[i].minParameters() <= this.material.numActionParameters) continue;
            this.actions[i] = null;
            warning = true;
        }
        return !warning;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.readStatementsFromNBT(data);
        for (PipeWire wire : PipeWire.VALUES) {
            this.broadcastSignal.set(wire.ordinal(), data.getBoolean("wireState[" + wire.ordinal() + "]"));
        }
        this.redstoneOutput = data.getByte("redstoneOutput");
    }

    public void openGui(EntityPlayer player) {
        if (!player.worldObj.isRemote) {
            player.openGui((Object)BuildCraftTransport.instance, 51, this.pipe.container.getWorldObj(), this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord);
            ((ContainerGateInterface)player.openContainer).setGate(this.direction.ordinal());
        }
    }

    public void tick() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.tick(this);
        }
    }

    public ItemStack getGateItem() {
        return ItemGate.makeGateItem(this);
    }

    public void dropGate() {
        this.pipe.dropItem(this.getGateItem());
    }

    public void resetGate() {
        if (this.redstoneOutput != 0) {
            this.redstoneOutput = 0;
            this.pipe.updateNeighbors(true);
        }
    }

    public boolean isGateActive() {
        for (ActionActiveState state : this.actionsState) {
            if (state != ActionActiveState.Activated) continue;
            return true;
        }
        return false;
    }

    public boolean isGatePulsing() {
        return this.isPulsing;
    }

    public int getRedstoneOutput() {
        return this.redstoneOutput;
    }

    public int getSidedRedstoneOutput() {
        return this.redstoneOutputSide;
    }

    public void setRedstoneOutput(boolean sideOnly, int value) {
        this.redstoneOutputSide = value;
        if (!sideOnly) {
            this.redstoneOutput = value;
        }
    }

    public void startResolution() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.startResolution();
        }
    }

    public void resolveActions() {
        boolean isActive;
        int it;
        int oldRedstoneOutput = this.redstoneOutput;
        this.redstoneOutput = 0;
        int oldRedstoneOutputSide = this.redstoneOutputSide;
        this.redstoneOutputSide = 0;
        boolean wasActive = this.activeActions.size() > 0;
        BitSet temp = this.prevBroadcastSignal;
        temp.clear();
        this.prevBroadcastSignal = this.broadcastSignal;
        this.broadcastSignal = temp;
        this.startResolution();
        int[] actionGroups = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < MAX_STATEMENTS; ++i) {
            for (int j = i - 1; j >= 0; --j) {
                if (this.actions[i] == null || this.actions[j] == null || !this.actions[i].getUniqueTag().equals(this.actions[j].getUniqueTag())) continue;
                boolean sameParams = true;
                for (int p = 0; p < MAX_PARAMETERS; ++p) {
                    if (!(this.actionParameters[i][p] != null && this.actionParameters[j][p] == null || this.actionParameters[i][p] == null && this.actionParameters[j][p] != null) && (this.actionParameters[i][p] == null || this.actionParameters[j][p] == null || this.actionParameters[i][p].equals(this.actionParameters[j][p]))) continue;
                    sameParams = false;
                }
                if (!sameParams) continue;
                actionGroups[i] = j;
            }
        }
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            this.actionsState[it] = ActionActiveState.Deactivated;
            IStatement trigger = this.triggers[it];
            IStatementParameter[] parameter = this.triggerParameters[it];
            if (trigger == null || !this.isTriggerActive(trigger, parameter)) continue;
            this.actionsState[it] = ActionActiveState.Partial;
        }
        this.activeActions.clear();
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            int j;
            boolean allActive = true;
            boolean oneActive = false;
            if (this.actions[it] == null) continue;
            for (j = 0; j < MAX_STATEMENTS; ++j) {
                if (actionGroups[j] != it) continue;
                if (this.actionsState[j] != ActionActiveState.Partial) {
                    allActive = false;
                    continue;
                }
                oneActive = true;
            }
            if (this.logic == GateDefinition.GateLogic.AND && allActive && oneActive || this.logic == GateDefinition.GateLogic.OR && oneActive) {
                if (this.logic == GateDefinition.GateLogic.AND) {
                    for (j = 0; j < MAX_STATEMENTS; ++j) {
                        if (actionGroups[j] != it) continue;
                        this.actionsState[j] = ActionActiveState.Activated;
                    }
                }
                StatementSlot slot = new StatementSlot();
                slot.statement = this.actions[it];
                slot.parameters = this.actionParameters[it];
                this.activeActions.add(slot);
            }
            if (this.logic != GateDefinition.GateLogic.OR || this.actionsState[it] != ActionActiveState.Partial) continue;
            this.actionsState[it] = ActionActiveState.Activated;
        }
        this.statementCounts.clear();
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            if (this.actionsState[it] != ActionActiveState.Activated) continue;
            this.statementCounts.add((Object)this.actions[it], 1);
        }
        for (StatementSlot slot : this.activeActions) {
            TileEntity tile;
            IStatement action = slot.statement;
            if (action instanceof IActionInternal) {
                ((IActionInternal)action).actionActivate(this, slot.parameters);
            } else {
                if (!(action instanceof IActionExternal)) continue;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    tile = this.getPipe().getTile().getNeighborTile(side);
                    if (tile == null) continue;
                    ((IActionExternal)action).actionActivate(tile, side, this, slot.parameters);
                }
            }
            if (this.resolveAction(action)) continue;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                tile = this.pipe.container.getTile(side);
                if (!(tile instanceof IActionReceptor)) continue;
                IActionReceptor recept = (IActionReceptor)tile;
                recept.actionActivated(action, slot.parameters);
            }
        }
        this.pipe.actionsActivated(this.activeActions);
        if (oldRedstoneOutput != this.redstoneOutput || oldRedstoneOutputSide != this.redstoneOutputSide) {
            this.pipe.updateNeighbors(true);
        }
        if (!this.prevBroadcastSignal.equals(this.broadcastSignal)) {
            this.pipe.updateSignalState();
        }
        boolean bl = isActive = this.activeActions.size() > 0;
        if (wasActive != isActive) {
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    public boolean resolveAction(IStatement action) {
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.resolveAction(action, this.statementCounts.count((Object)action))) continue;
            return true;
        }
        return false;
    }

    public boolean isTriggerActive(IStatement trigger, IStatementParameter[] parameters) {
        if (trigger == null) {
            return false;
        }
        if (trigger instanceof ITriggerInternal) {
            if (((ITriggerInternal)trigger).isTriggerActive(this, parameters)) {
                return true;
            }
        } else if (trigger instanceof ITriggerExternal) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.getPipe().getTile().getNeighborTile(side);
                if (tile == null || !((ITriggerExternal)trigger).isTriggerActive(tile, side, this, parameters)) continue;
                return true;
            }
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.isTriggerActive(trigger, parameters)) continue;
            return true;
        }
        return false;
    }

    public void addTriggers(List<ITriggerInternal> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || wire.ordinal() >= this.material.maxWireColor) continue;
            list.add(BuildCraftTransport.triggerPipeWireActive[wire.ordinal()]);
            list.add(BuildCraftTransport.triggerPipeWireInactive[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addTriggers(list);
        }
    }

    public List<IStatement> getAllValidTriggers() {
        ArrayList<IStatement> allTriggers = new ArrayList<IStatement>(64);
        allTriggers.addAll(StatementManager.getInternalTriggers(this));
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.pipe.container.getTile(o);
            allTriggers.addAll(StatementManager.getExternalTriggers(o, tile));
        }
        return allTriggers;
    }

    public void addActions(List<IActionInternal> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || wire.ordinal() >= this.material.maxWireColor) continue;
            list.add(BuildCraftTransport.actionPipeWire[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addActions(list);
        }
    }

    public List<IStatement> getAllValidActions() {
        ArrayList<IStatement> allActions = new ArrayList<IStatement>(64);
        allActions.addAll(StatementManager.getInternalActions(this));
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.pipe.container.getTile(o);
            allActions.addAll(StatementManager.getExternalActions(o, tile));
        }
        return allActions;
    }

    @Override
    public void setPulsing(boolean pulsing) {
        if (pulsing != this.isPulsing) {
            this.isPulsing = pulsing;
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    public float getPulseStage() {
        return this.pulseStage;
    }

    public void broadcastSignal(PipeWire color) {
        this.broadcastSignal.set(color.ordinal());
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public ForgeDirection getSide() {
        return this.direction;
    }

    @Override
    public TileEntity getTile() {
        return this.pipe.container;
    }
}

