/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.BCLog;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gui.ContainerDiamondPipe;
import buildcraft.transport.gui.ContainerEmeraldFluidPipe;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.gui.ContainerEmzuliPipe;
import buildcraft.transport.gui.ContainerFilteredBuffer;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.gui.GuiDiamondPipe;
import buildcraft.transport.gui.GuiEmeraldFluidPipe;
import buildcraft.transport.gui.GuiEmeraldPipe;
import buildcraft.transport.gui.GuiEmzuliPipe;
import buildcraft.transport.gui.GuiFilteredBuffer;
import buildcraft.transport.gui.GuiGateInterface;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class GuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        try {
            if (!world.blockExists(x, y, z)) {
                return null;
            }
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new ContainerFilteredBuffer(player.inventory, filteredBuffer);
            }
            if (!(tile instanceof TileGenericPipe)) {
                return null;
            }
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (pipe.pipe == null) {
                return null;
            }
            switch (id) {
                case 50: {
                    return new ContainerDiamondPipe((IInventory)player.inventory, (IDiamondPipe)((Object)pipe.pipe));
                }
                case 52: {
                    return new ContainerEmeraldPipe((IInventory)player.inventory, (PipeItemsEmerald)pipe.pipe);
                }
                case 53: {
                    return new ContainerEmzuliPipe((IInventory)player.inventory, (PipeItemsEmzuli)pipe.pipe);
                }
                case 54: {
                    return new ContainerEmeraldFluidPipe((IInventory)player.inventory, (PipeFluidsEmerald)pipe.pipe);
                }
                case 51: {
                    return new ContainerGateInterface((IInventory)player.inventory, pipe.pipe);
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.ERROR, "Failed to open GUI", (Throwable)ex);
            return null;
        }
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        try {
            if (!world.blockExists(x, y, z)) {
                return null;
            }
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new GuiFilteredBuffer(player.inventory, filteredBuffer);
            }
            if (!(tile instanceof TileGenericPipe)) {
                return null;
            }
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (pipe.pipe == null) {
                return null;
            }
            switch (id) {
                case 50: {
                    return new GuiDiamondPipe((IInventory)player.inventory, (IDiamondPipe)((Object)pipe.pipe));
                }
                case 52: {
                    return new GuiEmeraldPipe((IInventory)player.inventory, (PipeItemsEmerald)pipe.pipe);
                }
                case 53: {
                    return new GuiEmzuliPipe((IInventory)player.inventory, (PipeItemsEmzuli)pipe.pipe);
                }
                case 54: {
                    return new GuiEmeraldFluidPipe((IInventory)player.inventory, (PipeFluidsEmerald)pipe.pipe);
                }
                case 51: {
                    return new GuiGateInterface((IInventory)player.inventory, pipe.pipe);
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.ERROR, "Failed to open GUI", (Throwable)ex);
            return null;
        }
    }
}

