/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.utils.NBTUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GatePluggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemGateCopier
extends ItemBuildCraft {
    private IIcon[] icons;

    public ItemGateCopier() {
        this.setMaxStackSize(1);
        this.setUnlocalizedName("gateCopier");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndex(ItemStack i) {
        NBTTagCompound cpt = NBTUtils.getItemData(i);
        this.itemIcon = cpt.hasKey("logic") ? this.icons[1] : this.icons[0];
        return this.itemIcon;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        boolean isCopying = !player.isSneaking();
        Block block = world.getBlock(x, y, z);
        TileEntity tile = world.getTileEntity(x, y, z);
        NBTTagCompound data = NBTUtils.getItemData(stack);
        Gate gate = null;
        if (tile == null || !(tile instanceof TileGenericPipe) || !(block instanceof BlockGenericPipe)) {
            isCopying = true;
        } else {
            PipePluggable pluggable;
            BlockGenericPipe.RaytraceResult rayTraceResult = ((BlockGenericPipe)block).doRayTrace(world, x, y, z, player);
            if (rayTraceResult != null && rayTraceResult.boundingBox != null && rayTraceResult.hitPart == BlockGenericPipe.Part.Pluggable && (pluggable = ((TileGenericPipe)tile).getPipePluggable(rayTraceResult.sideHit)) instanceof GatePluggable) {
                gate = ((TileGenericPipe)tile).pipe.gates[rayTraceResult.sideHit.ordinal()];
            }
        }
        if (isCopying) {
            if (gate == null) {
                stack.setTagCompound(null);
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.clear", new Object[0]));
                return true;
            }
        } else {
            if (!data.hasKey("logic")) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noInformation", new Object[0]));
                return true;
            }
            if (gate == null) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noGate", new Object[0]));
                return true;
            }
            GateDefinition.GateMaterial dataMaterial = GateDefinition.GateMaterial.fromOrdinal(data.getByte("material"));
            GateDefinition.GateMaterial gateMaterial = gate.material;
            if (gateMaterial.numSlots < dataMaterial.numSlots) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.slots", new Object[0]));
            }
            if (gateMaterial.numActionParameters < dataMaterial.numActionParameters) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.actionParameters", new Object[0]));
            }
            if (gateMaterial.numTriggerParameters < dataMaterial.numTriggerParameters) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.triggerParameters", new Object[0]));
            }
            if (data.getByte("logic") != gate.logic.ordinal()) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.logic", new Object[0]));
            }
            gate.readStatementsFromNBT(data);
            if (!gate.verifyGateStatements()) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.load", new Object[0]));
            }
            ((TileGenericPipe)tile).sendUpdateToClient();
            player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gatePasted", new Object[0]));
            return true;
        }
        gate.writeStatementsToNBT(data);
        data.setByte("material", (byte)gate.material.ordinal());
        data.setByte("logic", (byte)gate.logic.ordinal());
        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gateCopied", new Object[0]));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[]{register.registerIcon("buildcraft:gateCopierOff"), register.registerIcon("buildcraft:gateCopierOn")};
    }
}

