/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pluggable.LensPluggable;
import java.util.LinkedList;
import net.minecraftforge.common.util.ForgeDirection;

public class LensFilterHandler {
    private IPipe pipe;

    public LensFilterHandler(IPipe pipe) {
        this.pipe = pipe;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        IPipeTile container = this.pipe.getTile();
        LinkedList<ForgeDirection> correctColored = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> notColored = new LinkedList<ForgeDirection>();
        boolean encounteredColor = false;
        int myColor = event.item.color == null ? -1 : event.item.color.ordinal();
        for (ForgeDirection dir : event.destinations) {
            IPipeTile otherContainer;
            IPipe otherPipe;
            int sideColor = -1;
            PipePluggable pluggable = container.getPipePluggable(dir);
            if (pluggable != null && pluggable instanceof LensPluggable && ((LensPluggable)pluggable).isFilter) {
                sideColor = ((LensPluggable)pluggable).color;
            }
            if ((otherPipe = container.getNeighborPipe(dir)) != null && otherPipe.getTile() != null && (pluggable = (otherContainer = otherPipe.getTile()).getPipePluggable(dir.getOpposite())) != null && pluggable instanceof LensPluggable && ((LensPluggable)pluggable).isFilter) {
                int otherColor = ((LensPluggable)pluggable).color;
                if (sideColor >= 0 && otherColor != sideColor) continue;
                sideColor = otherColor;
            }
            if (myColor == sideColor) {
                encounteredColor = true;
                correctColored.add(dir);
            }
            if (sideColor != -1) continue;
            notColored.add(dir);
        }
        event.destinations.clear();
        event.destinations.addAll(encounteredColor ? correctColored : notColored);
    }
}

