/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import io.netty.buffer.ByteBuf;

public class PipeRenderState
implements ISerializable {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    public byte glassColor = (byte)-1;
    private boolean dirty = true;

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.wireMatrix.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty();
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte((int)this.glassColor);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) {
        this.glassColor = data.readByte();
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
    }
}

