/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.MathUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportFluidsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.network.PacketFluidUpdate;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.events.PipeEventFluid;
import buildcraft.transport.utils.FluidRenderData;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PipeTransportFluids
extends PipeTransport
implements IFluidHandler {
    public static final Map<Class<? extends Pipe<?>>, Integer> fluidCapacities = new HashMap();
    public static int LIQUID_IN_PIPE = 250;
    public static short INPUT_TTL = (short)60;
    public static short OUTPUT_TTL = (short)80;
    public static short OUTPUT_COOLDOWN = (short)30;
    private static final ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
    private static final ForgeDirection[] orientations = ForgeDirection.values();
    public byte initClient = 0;
    public int travelDelay = 12;
    public int flowRate;
    public FluidRenderData[] renderCache = new FluidRenderData[orientations.length];
    public final PipeSection[] internalTanks = new PipeSection[orientations.length];
    private final TransferState[] transferState = new TransferState[directions.length];
    private final int[] inputPerTick = new int[directions.length];
    private final short[] inputTTL = new short[]{0, 0, 0, 0, 0, 0};
    private final short[] outputTTL = new short[]{OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL};
    private final short[] outputCooldown = new short[]{0, 0, 0, 0, 0, 0};
    private final SafeTimeTracker tracker = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private int clientSyncCounter = 0;

    public PipeTransportFluids() {
        for (ForgeDirection direction : orientations) {
            this.internalTanks[direction.ordinal()] = new PipeSection(this.getCapacity());
            if (direction == ForgeDirection.UNKNOWN) continue;
            this.transferState[direction.ordinal()] = TransferState.None;
        }
    }

    public void initFromPipe(Class<? extends Pipe> pipeClass) {
        this.flowRate = fluidCapacities.get(pipeClass);
        this.travelDelay = MathUtils.clamp(Math.round(16 / (this.flowRate / 10)), 1, 12);
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.FLUID;
    }

    public int getCapacity() {
        return LIQUID_IN_PIPE;
    }

    private boolean canReceiveFluid(ForgeDirection o) {
        Pipe pipe;
        TileEntity tile = this.container.getTile(o);
        if (!this.container.isPipeConnected(o)) {
            return false;
        }
        if (tile instanceof IPipeTile && ((pipe = (Pipe)((IPipeTile)tile).getPipe()) == null || !this.inputOpen(o.getOpposite()))) {
            return false;
        }
        return tile instanceof IFluidHandler;
    }

    @Override
    public void updateEntity() {
        if (this.container.getWorldObj().isRemote) {
            return;
        }
        this.moveFluids();
        if (this.tracker.markTimeIfDelay(this.container.getWorldObj())) {
            PacketFluidUpdate packet;
            boolean init = false;
            if ((long)(++this.clientSyncCounter) > BuildCraftCore.longUpdateFactor) {
                this.clientSyncCounter = 0;
                init = true;
            }
            if ((packet = this.computeFluidUpdate(init, true)) != null) {
                BuildCraftTransport.instance.sendToPlayers(packet, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
            }
        }
    }

    private PacketFluidUpdate computeFluidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        BitSet delta = new BitSet(PacketFluidUpdate.FLUID_DATA_NUM * ForgeDirection.VALID_DIRECTIONS.length);
        if (this.initClient > 0) {
            this.initClient = (byte)(this.initClient - 1);
            if (this.initClient == 1) {
                changed = true;
                delta.set(0, PacketFluidUpdate.FLUID_DATA_NUM * ForgeDirection.VALID_DIRECTIONS.length);
            }
        }
        FluidRenderData[] renderCacheCopy = (FluidRenderData[])this.renderCache.clone();
        for (ForgeDirection dir : orientations) {
            int displayQty;
            FluidStack prev;
            FluidStack current = this.internalTanks[dir.ordinal()].getFluid();
            FluidStack fluidStack = prev = renderCacheCopy[dir.ordinal()] != null ? renderCacheCopy[dir.ordinal()].getFluidStack() : null;
            if (current != null && current.getFluid() == null || prev == null && current == null) continue;
            if (prev == null ^ current == null) {
                changed = true;
                renderCacheCopy[dir.ordinal()] = current != null ? new FluidRenderData(current) : null;
                delta.set(dir.ordinal() * PacketFluidUpdate.FLUID_DATA_NUM + PacketFluidUpdate.FLUID_ID_BIT);
                delta.set(dir.ordinal() * PacketFluidUpdate.FLUID_DATA_NUM + PacketFluidUpdate.FLUID_AMOUNT_BIT);
                continue;
            }
            if (prev == null || current == null) continue;
            if (!prev.equals((Object)current) || initPacket) {
                changed = true;
                renderCacheCopy[dir.ordinal()] = new FluidRenderData(current);
                delta.set(dir.ordinal() * PacketFluidUpdate.FLUID_DATA_NUM + PacketFluidUpdate.FLUID_ID_BIT);
            }
            if ((displayQty = (prev.amount * 4 + current.amount) / 5) == 0 && current.amount > 0 || initPacket) {
                displayQty = current.amount;
            }
            if (prev.amount == (displayQty = Math.min(this.getCapacity(), displayQty)) && !initPacket) continue;
            changed = true;
            renderCacheCopy[dir.ordinal()].amount = displayQty;
            delta.set(dir.ordinal() * PacketFluidUpdate.FLUID_DATA_NUM + PacketFluidUpdate.FLUID_AMOUNT_BIT);
        }
        if (persistChange) {
            this.renderCache = renderCacheCopy;
        }
        if (changed || initPacket) {
            PacketFluidUpdate packet = new PacketFluidUpdate(this.container.xCoord, this.container.yCoord, this.container.zCoord, initPacket);
            packet.renderCache = renderCacheCopy;
            packet.delta = delta;
            return packet;
        }
        return null;
    }

    @Override
    public void sendDescriptionPacket() {
        super.sendDescriptionPacket();
        this.initClient = (byte)6;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (ForgeDirection direction : orientations) {
            if (nbttagcompound.hasKey("tank[" + direction.ordinal() + "]")) {
                this.internalTanks[direction.ordinal()].readFromNBT(nbttagcompound.getCompoundTag("tank[" + direction.ordinal() + "]"));
            }
            if (direction == ForgeDirection.UNKNOWN) continue;
            this.transferState[direction.ordinal()] = TransferState.values()[nbttagcompound.getShort("transferState[" + direction.ordinal() + "]")];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (ForgeDirection direction : orientations) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.internalTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.setTag("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
            if (direction == ForgeDirection.UNKNOWN) continue;
            nbttagcompound.setShort("transferState[" + direction.ordinal() + "]", (short)this.transferState[direction.ordinal()].ordinal());
        }
    }

    private void moveFluids() {
        int newTimeSlot = (int)(this.container.getWorldObj().getTotalWorldTime() % (long)this.travelDelay);
        short outputCount = this.computeCurrentConnectionStatesAndTickFlows((short)(newTimeSlot > 0 && newTimeSlot < this.travelDelay ? newTimeSlot : 0));
        this.moveFromPipe(outputCount);
        this.moveFromCenter(outputCount);
        this.moveToCenter();
    }

    private void moveFromPipe(short outputCount) {
        if (outputCount > 0) {
            for (ForgeDirection o : directions) {
                FluidStack liquidToPush;
                TileEntity target;
                if (this.transferState[o.ordinal()] != TransferState.Output || !((target = this.container.getTile(o)) instanceof IFluidHandler) || (liquidToPush = this.internalTanks[o.ordinal()].drain(this.flowRate, false)) == null || liquidToPush.amount <= 0) continue;
                int filled = ((IFluidHandler)target).fill(o.getOpposite(), liquidToPush, true);
                this.internalTanks[o.ordinal()].drain(filled, true);
                if (filled > 0) continue;
                int n = o.ordinal();
                this.outputTTL[n] = (short)(this.outputTTL[n] - 1);
            }
        }
    }

    private void moveFromCenter(short outputCount) {
        FluidStack pushStack = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getFluid();
        int totalAvailable = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getAvailable();
        if (totalAvailable < 1) {
            return;
        }
        if (pushStack != null) {
            FluidStack testStack = pushStack.copy();
            testStack.amount = this.flowRate;
            ArrayList<ForgeDirection> realDirections = new ArrayList<ForgeDirection>();
            for (ForgeDirection direction : directions) {
                if (this.transferState[direction.ordinal()] != TransferState.Output) continue;
                realDirections.add(direction);
            }
            this.container.pipe.eventBus.handleEvent(PipeEventFluid.FindDest.class, new PipeEventFluid.FindDest(pushStack, realDirections));
            for (ForgeDirection direction : realDirections) {
                FluidStack liquidToPush;
                int available = this.internalTanks[direction.ordinal()].fill(testStack, false);
                int ammountToPush = (int)((double)available / (double)this.flowRate / (double)outputCount * (double)Math.min(this.flowRate, totalAvailable));
                if (ammountToPush < 1) {
                    ++ammountToPush;
                }
                if ((liquidToPush = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(ammountToPush, false)) == null) continue;
                int filled = this.internalTanks[direction.ordinal()].fill(liquidToPush, true);
                this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(filled, true);
            }
        }
    }

    private void moveToCenter() {
        int transferInCount = 0;
        FluidStack stackInCenter = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].drain(this.flowRate, false);
        int spaceAvailable = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].getCapacity();
        if (stackInCenter != null) {
            spaceAvailable -= stackInCenter.amount;
        }
        for (ForgeDirection dir : directions) {
            FluidStack testStack;
            this.inputPerTick[dir.ordinal()] = 0;
            if (this.transferState[dir.ordinal()] == TransferState.Output || (testStack = this.internalTanks[dir.ordinal()].drain(this.flowRate, false)) == null || stackInCenter != null && !stackInCenter.isFluidEqual(testStack)) continue;
            this.inputPerTick[dir.ordinal()] = testStack.amount;
            ++transferInCount;
        }
        for (ForgeDirection dir : directions) {
            FluidStack liquidToPush;
            if (this.transferState[dir.ordinal()] == TransferState.Output || this.inputPerTick[dir.ordinal()] <= 0) continue;
            int ammountToDrain = (int)((double)this.inputPerTick[dir.ordinal()] / (double)this.flowRate / (double)transferInCount * (double)Math.min(this.flowRate, spaceAvailable));
            if (ammountToDrain < 1) {
                ++ammountToDrain;
            }
            if ((liquidToPush = this.internalTanks[dir.ordinal()].drain(ammountToDrain, false)) == null) continue;
            int filled = this.internalTanks[ForgeDirection.UNKNOWN.ordinal()].fill(liquidToPush, true);
            this.internalTanks[dir.ordinal()].drain(filled, true);
        }
    }

    private short computeCurrentConnectionStatesAndTickFlows(short newTimeSlot) {
        short outputCount = 0;
        for (ForgeDirection direction : orientations) {
            this.internalTanks[direction.ordinal()].setTime(newTimeSlot);
            this.internalTanks[direction.ordinal()].moveFluids();
            if (direction == ForgeDirection.UNKNOWN) continue;
            if (this.transferState[direction.ordinal()] == TransferState.Input) {
                int n = direction.ordinal();
                this.inputTTL[n] = (short)(this.inputTTL[n] - 1);
                if (this.inputTTL[direction.ordinal()] > 0) continue;
                this.transferState[direction.ordinal()] = TransferState.None;
                continue;
            }
            if (!this.container.pipe.outputOpen(direction)) {
                this.transferState[direction.ordinal()] = TransferState.None;
                continue;
            }
            if (this.outputCooldown[direction.ordinal()] > 0) {
                int n = direction.ordinal();
                this.outputCooldown[n] = (short)(this.outputCooldown[n] - 1);
                continue;
            }
            if (this.outputTTL[direction.ordinal()] <= 0) {
                this.transferState[direction.ordinal()] = TransferState.None;
                this.outputCooldown[direction.ordinal()] = OUTPUT_COOLDOWN;
                this.outputTTL[direction.ordinal()] = OUTPUT_TTL;
                continue;
            }
            if (!this.canReceiveFluid(direction) || !this.outputOpen(direction)) continue;
            this.transferState[direction.ordinal()] = TransferState.Output;
            outputCount = (short)(outputCount + 1);
        }
        return outputCount;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection direction : directions) {
            if (this.container.isPipeConnected(direction)) continue;
            this.internalTanks[direction.ordinal()].reset();
            this.transferState[direction.ordinal()] = TransferState.None;
            this.renderCache[direction.ordinal()] = null;
        }
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe2 = (Pipe)((IPipeTile)tile).getPipe()) && !(pipe2.transport instanceof PipeTransportFluids)) {
            return false;
        }
        if (tile instanceof IFluidHandler) {
            IFluidHandler liq = (IFluidHandler)tile;
            return true;
        }
        return tile instanceof IPipeTile;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(from.ordinal(), resource, doFill);
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        ForgeDirection d = ForgeDirection.getOrientation((int)tankIndex);
        if (d != ForgeDirection.UNKNOWN && !this.inputOpen(d)) {
            return 0;
        }
        for (int i = 0; i <= 6; ++i) {
            if (this.internalTanks[i].getFluid() == null || this.internalTanks[i].getFluid().isFluidEqual(resource)) continue;
            return 0;
        }
        int filled = this.container.pipe instanceof IPipeTransportFluidsHook ? ((IPipeTransportFluidsHook)((Object)this.container.pipe)).fill(orientations[tankIndex], resource, doFill) : this.internalTanks[tankIndex].fill(resource, doFill);
        if (filled > 0 && doFill && tankIndex != ForgeDirection.UNKNOWN.ordinal()) {
            this.transferState[tankIndex] = TransferState.Input;
            this.inputTTL[tankIndex] = INPUT_TTL;
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.inputOpen(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.internalTanks[from.ordinal()])};
    }

    static {
        fluidCapacities.put(PipeFluidsCobblestone.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsDiamond.class, 8 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsEmerald.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsGold.class, 8 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsIron.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsQuartz.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsSandstone.class, 2 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsStone.class, 2 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsVoid.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsWood.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
    }

    public static enum TransferState {
        None,
        Input,
        Output;

    }

    public class PipeSection
    extends FluidTank {
        private short currentTime;
        private short[] incomming;

        public PipeSection(int capacity) {
            super(null, capacity);
            this.currentTime = 0;
            this.incomming = new short[PipeTransportFluids.this.travelDelay];
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int maxToFill = Math.min(resource.amount, PipeTransportFluids.this.flowRate - this.incomming[this.currentTime]);
            if (maxToFill <= 0) {
                return 0;
            }
            FluidStack stackToFill = resource.copy();
            stackToFill.amount = maxToFill;
            int filled = super.fill(stackToFill, doFill);
            if (doFill) {
                short s = this.currentTime;
                this.incomming[s] = (short)(this.incomming[s] + filled);
            }
            return filled;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            int maxToDrain = this.getAvailable();
            if (maxToDrain > maxDrain) {
                maxToDrain = maxDrain;
            }
            if (maxToDrain > PipeTransportFluids.this.flowRate) {
                maxToDrain = PipeTransportFluids.this.flowRate;
            }
            if (maxToDrain <= 0) {
                return null;
            }
            return super.drain(maxToDrain, doDrain);
        }

        public void moveFluids() {
            this.incomming[this.currentTime] = 0;
        }

        public void setTime(short newTime) {
            this.currentTime = newTime;
        }

        public void reset() {
            this.setFluid(null);
            this.incomming = new short[PipeTransportFluids.this.travelDelay];
        }

        public int getAvailable() {
            int all = this.getFluidAmount();
            for (short slot : this.incomming) {
                all -= slot;
            }
            return all;
        }

        public FluidTank readFromNBT(NBTTagCompound compoundTag) {
            this.setCapacity(compoundTag.getInteger("capacity"));
            for (int i = 0; i < PipeTransportFluids.this.travelDelay; ++i) {
                this.incomming[i] = compoundTag.getShort("in[" + i + "]");
            }
            this.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)compoundTag));
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound subTag) {
            subTag.setInteger("capacity", this.getCapacity());
            for (int i = 0; i < PipeTransportFluids.this.travelDelay; ++i) {
                this.incomming[i] = subTag.getShort("in[" + i + "]");
            }
            if (this.getFluid() != null) {
                this.getFluid().writeToNBT(subTag);
            }
            return subTag;
        }
    }
}

