/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TravelerSet;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class PipeTransportItems
extends PipeTransport {
    public static final int MAX_PIPE_STACKS = 64;
    public static final int MAX_PIPE_ITEMS = 1024;
    public boolean allowBouncing = false;
    public final TravelerSet items = new TravelerSet(this);

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    public void readjustSpeed(TravelingItem item) {
        PipeEventItem.AdjustSpeed event = new PipeEventItem.AdjustSpeed(item);
        this.container.pipe.eventBus.handleEvent(PipeEventItem.AdjustSpeed.class, event);
        if (!event.handled) {
            this.defaultReajustSpeed(item);
        }
    }

    public void defaultReajustSpeed(TravelingItem item) {
        float speed = item.getSpeed();
        if (speed > 0.01f) {
            speed -= 0.01f;
        }
        if (speed < 0.01f) {
            speed = 0.01f;
        }
        item.setSpeed(speed);
    }

    private void readjustPosition(TravelingItem item) {
        double x = MathUtils.clamp(item.xCoord, (double)this.container.xCoord + 0.01, (double)this.container.xCoord + 0.99);
        double y = MathUtils.clamp(item.yCoord, (double)this.container.yCoord + 0.01, (double)this.container.yCoord + 0.99);
        double z = MathUtils.clamp(item.zCoord, (double)this.container.zCoord + 0.01, (double)this.container.zCoord + 0.99);
        if (item.input != ForgeDirection.UP && item.input != ForgeDirection.DOWN) {
            y = (float)this.container.yCoord + TransportUtils.getPipeFloorOf(item.getItemStack());
        }
        item.setPosition(x, y, z);
    }

    public void injectItem(TravelingItem item, ForgeDirection inputOrientation) {
        if (item.isCorrupted()) {
            return;
        }
        item.reset();
        item.input = inputOrientation;
        this.readjustSpeed(item);
        this.readjustPosition(item);
        if (!this.container.getWorldObj().isRemote) {
            item.output = this.resolveDestination(item);
        }
        PipeEventItem.Entered event = new PipeEventItem.Entered(item);
        this.container.pipe.eventBus.handleEvent(PipeEventItem.Entered.class, event);
        if (event.cancelled) {
            return;
        }
        this.items.add(item);
        if (!this.container.getWorldObj().isRemote) {
            this.sendTravelerPacket(item, false);
            if (this.items.size() > BuildCraftTransport.groupItemsTrigger) {
                this.groupEntities();
            }
            if (this.items.size() > 64) {
                BCLog.logger.log(Level.WARN, String.format("Pipe exploded at %d,%d,%d because it had too many stacks: %d", this.container.xCoord, this.container.yCoord, this.container.zCoord, this.items.size()));
                this.destroyPipe();
                return;
            }
            int numItems = 0;
            Iterator<TravelingItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                TravelingItem travellingItem = iterator.next();
                ItemStack stack = travellingItem.getItemStack();
                if (stack == null || stack.stackSize <= 0) continue;
                numItems += stack.stackSize;
            }
            if (numItems > 1024) {
                BCLog.logger.log(Level.WARN, String.format("Pipe exploded at %d,%d,%d because it had too many items: %d", this.container.xCoord, this.container.yCoord, this.container.zCoord, numItems));
                this.destroyPipe();
            }
        }
    }

    private void destroyPipe() {
        BlockUtils.explodeBlock(this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord);
        this.container.getWorldObj().setBlockToAir(this.container.xCoord, this.container.yCoord, this.container.zCoord);
    }

    protected void reverseItem(TravelingItem item) {
        if (item.isCorrupted()) {
            return;
        }
        item.toCenter = true;
        item.input = item.output.getOpposite();
        this.readjustSpeed(item);
        this.readjustPosition(item);
        if (!this.container.getWorldObj().isRemote) {
            item.output = this.resolveDestination(item);
        }
        PipeEventItem.Entered event = new PipeEventItem.Entered(item);
        this.container.pipe.eventBus.handleEvent(PipeEventItem.Entered.class, event);
        if (event.cancelled) {
            return;
        }
        this.items.unscheduleRemoval(item);
        if (!this.container.getWorldObj().isRemote) {
            this.sendTravelerPacket(item, true);
        }
    }

    public ForgeDirection resolveDestination(TravelingItem data) {
        List<ForgeDirection> validDestinations = this.getPossibleMovements(data);
        if (validDestinations.isEmpty()) {
            return ForgeDirection.UNKNOWN;
        }
        return validDestinations.get(0);
    }

    public List<ForgeDirection> getPossibleMovements(TravelingItem item) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        item.blacklist.add(item.input.getOpposite());
        EnumSet<ForgeDirection> sides = EnumSet.complementOf(item.blacklist);
        sides.remove(ForgeDirection.UNKNOWN);
        for (ForgeDirection o : sides) {
            if (!this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, item)) continue;
            result.add(o);
        }
        PipeEventItem.FindDest event = new PipeEventItem.FindDest(item, result);
        this.container.pipe.eventBus.handleEvent(PipeEventItem.FindDest.class, event);
        if (this.allowBouncing && result.isEmpty() && this.canReceivePipeObjects(item.input.getOpposite(), item)) {
            result.add(item.input.getOpposite());
        }
        Collections.shuffle(result);
        return result;
    }

    private boolean canReceivePipeObjects(ForgeDirection o, TravelingItem item) {
        TileEntity entity = this.container.getTile(o);
        if (!this.container.isPipeConnected(o)) {
            return false;
        }
        if (entity instanceof IPipeTile) {
            Pipe pipe = (Pipe)((IPipeTile)entity).getPipe();
            if (pipe == null || pipe.transport == null) {
                return false;
            }
            if (pipe == null || pipe.transport == null) {
                return false;
            }
            return pipe.inputOpen(o.getOpposite()) && pipe.transport instanceof PipeTransportItems;
        }
        return entity instanceof IInventory && item.getInsertionHandler().canInsertItem(item, (IInventory)entity) && Transactor.getTransactorFor((Object)entity).add((ItemStack)item.getItemStack(), (ForgeDirection)o.getOpposite(), (boolean)false).stackSize > 0;
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    private void moveSolids() {
        this.items.flush();
        if (!this.container.getWorldObj().isRemote) {
            this.items.purgeCorruptedItems();
        }
        this.items.iterating = true;
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.getContainer() != this.container) {
                this.items.scheduleRemoval(item);
                continue;
            }
            Position motion = new Position(0.0, 0.0, 0.0, item.toCenter ? item.input : item.output);
            motion.moveForwards(item.getSpeed());
            item.movePosition(motion.x, motion.y, motion.z);
            if (item.toCenter && this.middleReached(item) || this.outOfBounds(item)) {
                item.toCenter = false;
                item.setPosition((double)this.container.xCoord + 0.5, (float)this.container.yCoord + TransportUtils.getPipeFloorOf(item.getItemStack()), (double)this.container.zCoord + 0.5);
                if (item.output == ForgeDirection.UNKNOWN) {
                    if (!this.items.scheduleRemoval(item)) continue;
                    this.dropItem(item);
                    continue;
                }
                PipeEventItem.ReachedCenter event = new PipeEventItem.ReachedCenter(item);
                this.container.pipe.eventBus.handleEvent(PipeEventItem.ReachedCenter.class, event);
                continue;
            }
            if (item.toCenter || !this.endReached(item)) continue;
            TileEntity tile = this.container.getTile(item.output);
            PipeEventItem.ReachedEnd event = new PipeEventItem.ReachedEnd(item, tile);
            this.container.pipe.eventBus.handleEvent(PipeEventItem.ReachedEnd.class, event);
            boolean handleItem = !event.handled;
            if (!handleItem || !this.items.scheduleRemoval(item)) continue;
            this.handleTileReached(item, tile);
        }
        this.items.iterating = false;
        this.items.flush();
    }

    private boolean passToNextPipe(TravelingItem item, TileEntity tile) {
        Pipe pipe;
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe = (Pipe)((IPipeTile)tile).getPipe()) && pipe.transport instanceof PipeTransportItems) {
            ((PipeTransportItems)pipe.transport).injectItem(item, item.output);
            return true;
        }
        return false;
    }

    private void handleTileReached(TravelingItem item, TileEntity tile) {
        if (!this.passToNextPipe(item, tile)) {
            if (tile instanceof IInventory) {
                if (!this.container.getWorldObj().isRemote) {
                    if (item.getInsertionHandler().canInsertItem(item, (IInventory)tile)) {
                        ItemStack added = Transactor.getTransactorFor(tile).add(item.getItemStack(), item.output.getOpposite(), true);
                        item.getItemStack().stackSize -= added.stackSize;
                    }
                    if (item.getItemStack().stackSize > 0) {
                        this.reverseItem(item);
                    }
                }
            } else {
                this.dropItem(item);
            }
        }
    }

    private void dropItem(TravelingItem item) {
        if (this.container.getWorldObj().isRemote) {
            return;
        }
        PipeEventItem.DropItem event = new PipeEventItem.DropItem(item, item.toEntityItem());
        this.container.pipe.eventBus.handleEvent(PipeEventItem.DropItem.class, event);
        if (event.entity == null) {
            return;
        }
        EntityItem entity = event.entity;
        ForgeDirection direction = item.input;
        entity.setPosition(entity.posX + (double)direction.offsetX * 0.5, entity.posY + (double)direction.offsetY * 0.5, entity.posZ + (double)direction.offsetZ * 0.5);
        entity.motionX = (double)((float)direction.offsetX * item.speed * 5.0f) + this.getWorld().rand.nextGaussian() * 0.1;
        entity.motionY = (double)((float)direction.offsetY * item.speed * 5.0f) + this.getWorld().rand.nextGaussian() * 0.1;
        entity.motionZ = (double)((float)direction.offsetZ * item.speed * 5.0f) + this.getWorld().rand.nextGaussian() * 0.1;
        this.container.getWorldObj().spawnEntityInWorld((Entity)entity);
    }

    protected boolean middleReached(TravelingItem item) {
        float middleLimit = item.getSpeed() * 1.01f;
        return Math.abs((double)this.container.xCoord + 0.5 - item.xCoord) < (double)middleLimit && Math.abs((double)((float)this.container.yCoord + TransportUtils.getPipeFloorOf(item.getItemStack())) - item.yCoord) < (double)middleLimit && Math.abs((double)this.container.zCoord + 0.5 - item.zCoord) < (double)middleLimit;
    }

    protected boolean endReached(TravelingItem item) {
        return item.xCoord > (double)(this.container.xCoord + 1) || item.xCoord < (double)this.container.xCoord || item.yCoord > (double)(this.container.yCoord + 1) || item.yCoord < (double)this.container.yCoord || item.zCoord > (double)(this.container.zCoord + 1) || item.zCoord < (double)this.container.zCoord;
    }

    protected boolean outOfBounds(TravelingItem item) {
        return item.xCoord > (double)(this.container.xCoord + 2) || item.xCoord < (double)(this.container.xCoord - 1) || item.yCoord > (double)(this.container.yCoord + 2) || item.yCoord < (double)(this.container.yCoord - 1) || item.zCoord > (double)(this.container.zCoord + 2) || item.zCoord < (double)(this.container.zCoord - 1);
    }

    public Position getPosition() {
        return new Position(this.container.xCoord, this.container.yCoord, this.container.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.getTagList("travelingEntities", 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.getCompoundTagAt(j);
                TravelingItem item = TravelingItem.make(dataTag);
                if (item.isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.appendTag((NBTBase)dataTag);
            item.writeToNBT(dataTag);
        }
        nbt.setTag("travelingEntities", (NBTBase)nbttaglist);
    }

    protected void doWork() {
    }

    public void handleTravelerPacket(PacketPipeTransportTraveler packet) {
        TravelingItem item = TravelingItem.clientCache.get(packet.getTravelingEntityId());
        if (item == null) {
            item = TravelingItem.make(packet.getTravelingEntityId());
        }
        if (item.getContainer() != this.container) {
            this.items.add(item);
        }
        if (packet.forceStackRefresh() || item.getItemStack() == null) {
            BuildCraftTransport.instance.sendToServer(new PacketPipeTransportItemStackRequest(packet.getTravelingEntityId()));
        }
        item.setPosition(packet.getItemX(), packet.getItemY(), packet.getItemZ());
        item.setSpeed(packet.getSpeed());
        item.toCenter = true;
        item.input = packet.getInputOrientation();
        item.output = packet.getOutputOrientation();
        item.color = packet.getColor();
    }

    private void sendTravelerPacket(TravelingItem data, boolean forceStackRefresh) {
        PacketPipeTransportTraveler packet = new PacketPipeTransportTraveler(data, forceStackRefresh);
        BuildCraftTransport.instance.sendToPlayers(packet, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
    }

    public int getNumberOfStacks() {
        return this.items.size();
    }

    public int getNumberOfItems() {
        int num = 0;
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.getItemStack() == null) continue;
            num += item.getItemStack().stackSize;
        }
        return num;
    }

    protected void neighborChange() {
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe2 = (Pipe)((IPipeTile)tile).getPipe()) && !(pipe2.transport instanceof PipeTransportItems)) {
            return false;
        }
        if (tile instanceof ISidedInventory) {
            int[] slots = ((ISidedInventory)tile).getAccessibleSlotsFromSide(side.getOpposite().ordinal());
            return slots != null && slots.length > 0;
        }
        return tile instanceof IPipeTile || tile instanceof IInventory && ((IInventory)tile).getSizeInventory() > 0;
    }

    public void groupEntities() {
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem otherItem;
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            Iterator<TravelingItem> iterator2 = this.items.iterator();
            while (iterator2.hasNext() && !item.tryMergeInto(otherItem = iterator2.next())) {
            }
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            this.container.pipe.dropItem(item.getItemStack());
        }
        this.items.clear();
    }

    @Override
    public List<ItemStack> getDroppedItems() {
        this.groupEntities();
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>(this.items.size());
        Iterator<TravelingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (item.isCorrupted()) continue;
            itemsDropped.add(item.getItemStack());
        }
        return itemsDropped;
    }

    @Override
    public boolean delveIntoUnloadedChunks() {
        return true;
    }
}

