/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IEngine;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.DefaultProps;
import buildcraft.core.TileBuildCraft;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    public static final Map<Class<? extends Pipe<?>>, Integer> powerCapacities = new HashMap();
    private static final int DISPLAY_SMOOTHING = 10;
    private static final int OVERLOAD_TICKS = 60;
    public short[] displayPower = new short[6];
    public int overload;
    public int[] nextPowerQuery = new int[6];
    public int[] internalNextPower = new int[6];
    public int maxPower = 80;
    private boolean needsInit = true;
    private TileEntity[] tiles = new TileEntity[6];
    private short[] prevDisplayPower = new short[6];
    private int[] powerQuery = new int[6];
    private long currentDate;
    private int[] internalPower = new int[6];
    private int[] externalPower = new int[6];
    private SafeTimeTracker tracker = new SafeTimeTracker(2 * BuildCraftCore.updateFactor);

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.POWER;
    }

    public void initFromPipe(Class<? extends Pipe> pipeClass) {
        this.maxPower = powerCapacities.get(pipeClass);
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        IEnergyConnection handler;
        if (tile instanceof IPipeTile) {
            Pipe pipe2 = (Pipe)((IPipeTile)tile).getPipe();
            return !BlockGenericPipe.isValid(pipe2) || pipe2.transport instanceof PipeTransportPower;
        }
        if (this.container.pipe instanceof PipePowerWood) {
            return this.isPowerSource(tile, side);
        }
        if (tile instanceof IEngine) {
            return false;
        }
        return (tile instanceof IEnergyHandler || tile instanceof IEnergyReceiver) && (handler = (IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    public boolean isPowerSource(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileBuildCraft && !(tile instanceof IEngine)) {
            return false;
        }
        if (tile instanceof IRedstoneEngine) {
            return false;
        }
        return tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.updateTile(side);
        }
    }

    private void updateTile(ForgeDirection side) {
        TileEntity tile = this.container.getTile(side);
        if (tile != null && this.container.isPipeConnected(side)) {
            this.tiles[side.ordinal()] = tile;
        } else {
            this.tiles[side.ordinal()] = null;
            this.internalPower[side.ordinal()] = 0;
            this.internalNextPower[side.ordinal()] = 0;
            this.displayPower[side.ordinal()] = 0;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.updateTile(side);
            }
        }
    }

    private Object getEnergyProvider(int side) {
        PipePluggable pp;
        ForgeDirection fs = ForgeDirection.getOrientation((int)side);
        if (this.container.hasPipePluggable(fs) && (pp = this.container.getPipePluggable(fs)) instanceof IEnergyReceiver) {
            return pp;
        }
        return this.tiles[side];
    }

    @Override
    public void updateEntity() {
        int i;
        if (this.container.getWorldObj().isRemote) {
            return;
        }
        this.step();
        this.init();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.tiles[side.ordinal()] == null || !this.tiles[side.ordinal()].isInvalid()) continue;
            this.updateTile(side);
        }
        System.arraycopy(this.displayPower, 0, this.prevDisplayPower, 0, 6);
        Arrays.fill(this.displayPower, (short)0);
        for (int i2 = 0; i2 < 6; ++i2) {
            Object ep;
            int j;
            if (this.internalPower[i2] <= 0) continue;
            float totalPowerQuery = 0.0f;
            for (j = 0; j < 6; ++j) {
                if (j == i2 || this.powerQuery[j] <= 0 || !((ep = this.getEnergyProvider(j)) instanceof IPipeTile) && !(ep instanceof IEnergyReceiver) && !(ep instanceof IEnergyHandler)) continue;
                totalPowerQuery += (float)this.powerQuery[j];
            }
            if (!(totalPowerQuery > 0.0f)) continue;
            for (j = 0; j < 6; ++j) {
                IEnergyReceiver handler;
                if (j == i2 || this.powerQuery[j] <= 0) continue;
                ep = this.getEnergyProvider(j);
                int watts = (int)Math.floor((float)(this.internalPower[i2] * this.powerQuery[j]) / totalPowerQuery);
                if (ep instanceof IPipeTile) {
                    Pipe nearbyPipe = (Pipe)((IPipeTile)ep).getPipe();
                    PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyPipe.transport;
                    watts = nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts);
                    int n = i2;
                    this.internalPower[n] = this.internalPower[n] - watts;
                } else if (ep instanceof IEnergyHandler) {
                    handler = (IEnergyHandler)ep;
                    if (handler.canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite())) {
                        watts = handler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts, false);
                        int n = i2;
                        this.internalPower[n] = this.internalPower[n] - watts;
                    }
                } else if (ep instanceof IEnergyReceiver && (handler = (IEnergyReceiver)ep).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite())) {
                    watts = handler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts, false);
                    int n = i2;
                    this.internalPower[n] = this.internalPower[n] - watts;
                }
                int n = j;
                this.displayPower[n] = (short)(this.displayPower[n] + watts);
                int n2 = i2;
                this.displayPower[n2] = (short)(this.displayPower[n2] + watts);
            }
        }
        float highestPower = 0.0f;
        for (int i3 = 0; i3 < 6; ++i3) {
            this.displayPower[i3] = (short)Math.floor((float)(this.prevDisplayPower[i3] * 9 + this.displayPower[i3]) / 10.0f);
            if (!((float)this.displayPower[i3] > highestPower)) continue;
            highestPower = this.displayPower[i3];
        }
        this.overload += highestPower > (float)this.maxPower * 0.95f ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int request;
            IEnergyReceiver handler;
            Object tile;
            if (!this.outputOpen(dir) || (tile = this.getEnergyProvider(dir.ordinal())) instanceof IPipeTile && ((Pipe)((IPipeTile)tile).getPipe()).transport instanceof PipeTransportPower) continue;
            if (tile instanceof IEnergyHandler) {
                handler = (IEnergyHandler)tile;
                if (!handler.canConnectEnergy(dir.getOpposite()) || (request = handler.receiveEnergy(dir.getOpposite(), this.maxPower, true)) <= 0) continue;
                this.requestEnergy(dir, request);
                continue;
            }
            if (!(tile instanceof IEnergyReceiver) || !(handler = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite()) || (request = handler.receiveEnergy(dir.getOpposite(), this.maxPower, true)) <= 0) continue;
            this.requestEnergy(dir, request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            if (!this.inputOpen(ForgeDirection.getOrientation((int)i))) continue;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            IPipeTile nearbyTile;
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof IPipeTile) || (nearbyTile = (IPipeTile)entity).getPipe() == null) continue;
            PipeTransportPower nearbyTransport = (PipeTransportPower)((Pipe)nearbyTile.getPipe()).transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.container.getWorldObj())) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.container.xCoord, this.container.yCoord, this.container.zCoord);
            packet.displayPower = this.displayPower;
            packet.overload = this.isOverloaded();
            BuildCraftTransport.instance.sendToPlayers(packet, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    private void step() {
        if (this.container != null && this.container.getWorldObj() != null && this.currentDate != this.container.getWorldObj().getTotalWorldTime()) {
            this.currentDate = this.container.getWorldObj().getTotalWorldTime();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            int[] next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }
    }

    public int receiveEnergy(ForgeDirection from, int valI) {
        int ret;
        int val = valI;
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook && (ret = ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val)) >= 0) {
            return ret;
        }
        int side = from.ordinal();
        if (this.internalNextPower[side] > this.maxPower) {
            return 0;
        }
        int n = side;
        this.internalNextPower[n] = this.internalNextPower[n] + val;
        if (this.internalNextPower[side] > this.maxPower) {
            this.internalNextPower[side] = this.maxPower;
            if ((val -= this.internalNextPower[side] - this.maxPower) < 0) {
                val = 0;
            }
        }
        return val;
    }

    public void requestEnergy(ForgeDirection from, int amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.container.getWorldObj().getTotalWorldTime();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.getInteger("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.getInteger("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.getInteger("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.getInteger("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.setInteger("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.setInteger("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.setInteger("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.setInteger("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.displayPower = packetPower.displayPower;
        this.overload = packetPower.overload ? 60 : 0;
    }

    public int consumePower(ForgeDirection dir, int max) {
        int result;
        if (this.externalPower[dir.ordinal()] < max) {
            result = this.externalPower[dir.ordinal()];
            this.externalPower[dir.ordinal()] = 0;
        } else {
            result = max;
            int n = dir.ordinal();
            this.externalPower[n] = this.externalPower[n] - max;
        }
        return result;
    }

    public boolean isQueryingPower() {
        for (int d : this.powerQuery) {
            if (d <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        powerCapacities.put(PipePowerCobblestone.class, 80);
        powerCapacities.put(PipePowerStone.class, 160);
        powerCapacities.put(PipePowerWood.class, 320);
        powerCapacities.put(PipePowerSandstone.class, 320);
        powerCapacities.put(PipePowerQuartz.class, 640);
        powerCapacities.put(PipePowerIron.class, 1280);
        powerCapacities.put(PipePowerGold.class, 2560);
        powerCapacities.put(PipePowerEmerald.class, 2560);
        powerCapacities.put(PipePowerDiamond.class, 10240);
    }
}

