/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.statements.TriggerPipeContents;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTriggerProvider
implements ITriggerProvider {
    public LinkedList<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        LinkedList<ITriggerInternal> result = new LinkedList<ITriggerInternal>();
        Pipe pipe = null;
        TileEntity tile = container.getTile();
        if (tile instanceof TileGenericPipe) {
            pipe = ((TileGenericPipe)tile).pipe;
        }
        if (pipe == null) {
            return result;
        }
        boolean containsGate = false;
        for (Gate gate : pipe.gates) {
            if (gate == null) continue;
            containsGate = true;
            gate.addTriggers(result);
        }
        result.add(BuildCraftCore.triggerRedstoneActive);
        result.add(BuildCraftCore.triggerRedstoneInactive);
        switch (((TileGenericPipe)tile).getPipeType()) {
            case ITEM: {
                result.add(TriggerPipeContents.PipeContents.empty.trigger);
                result.add(TriggerPipeContents.PipeContents.containsItems.trigger);
                break;
            }
            case FLUID: {
                result.add(TriggerPipeContents.PipeContents.empty.trigger);
                result.add(TriggerPipeContents.PipeContents.containsFluids.trigger);
                break;
            }
            case POWER: {
                result.add(TriggerPipeContents.PipeContents.empty.trigger);
                result.add(TriggerPipeContents.PipeContents.containsEnergy.trigger);
                result.add(TriggerPipeContents.PipeContents.tooMuchEnergy.trigger);
                result.add(TriggerPipeContents.PipeContents.requestsEnergy.trigger);
                break;
            }
        }
        return result;
    }

    public LinkedList<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> result = new LinkedList<ITriggerExternal>();
        return result;
    }
}

