/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.SimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileFilteredBuffer
extends TileBuildCraft
implements IInventory {
    private final SimpleInventory inventoryFilters = new SimpleInventory(9, "FilteredBufferFilters", 1);
    private final SimpleInventory inventoryStorage = new SimpleInventory(9, "FilteredBufferStorage", 64);

    @Override
    public void updateEntity() {
        super.updateEntity();
    }

    public IInventory getFilters() {
        return this.inventoryFilters;
    }

    public int getSizeInventory() {
        return this.inventoryStorage.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inventoryStorage.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        return this.inventoryStorage.decrStackSize(slotId, count);
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        return this.inventoryStorage.getStackInSlotOnClosing(slotId);
    }

    public void setInventorySlotContents(int slotId, ItemStack itemStack) {
        this.inventoryStorage.setInventorySlotContents(slotId, itemStack);
    }

    public String getInventoryName() {
        return this.inventoryStorage.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventoryStorage.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        ItemStack filterItemStack = this.inventoryFilters.getStackInSlot(i);
        if (filterItemStack == null || filterItemStack.getItem() != itemstack.getItem()) {
            return false;
        }
        if (itemstack.getItem().isDamageable()) {
            return true;
        }
        return filterItemStack.getItemDamage() == itemstack.getItemDamage();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagCompound inventoryStorageTag = nbtTagCompound;
        if (nbtTagCompound.hasKey("inventoryStorage")) {
            inventoryStorageTag = (NBTTagCompound)nbtTagCompound.getTag("inventoryStorage");
        }
        this.inventoryStorage.readFromNBT(inventoryStorageTag);
        NBTTagCompound inventoryFiltersTag = (NBTTagCompound)nbtTagCompound.getTag("inventoryFilters");
        this.inventoryFilters.readFromNBT(inventoryFiltersTag);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        this.inventoryStorage.writeToNBT(nbtTagCompound);
        NBTTagCompound inventoryFiltersTag = new NBTTagCompound();
        this.inventoryFilters.writeToNBT(inventoryFiltersTag);
        nbtTagCompound.setTag("inventoryFilters", (NBTBase)inventoryFiltersTag);
    }

    public boolean hasCustomInventoryName() {
        return false;
    }
}

