/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.ItemGate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public final class GateFactory {
    private GateFactory() {
    }

    public static Gate makeGate(Pipe<?> pipe, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic, ForgeDirection direction) {
        return new Gate(pipe, material, logic, direction);
    }

    public static Gate makeGate(Pipe<?> pipe, ItemStack stack, ForgeDirection direction) {
        if (stack == null || stack.stackSize <= 0 || !(stack.getItem() instanceof ItemGate)) {
            return null;
        }
        Gate gate = GateFactory.makeGate(pipe, ItemGate.getMaterial(stack), ItemGate.getLogic(stack), direction);
        for (IGateExpansion expansion : ItemGate.getInstalledExpansions(stack)) {
            gate.addGateExpansion(expansion);
        }
        return gate;
    }

    public static Gate makeGate(Pipe<?> pipe, NBTTagCompound nbt) {
        GateDefinition.GateMaterial material = GateDefinition.GateMaterial.REDSTONE;
        GateDefinition.GateLogic logic = GateDefinition.GateLogic.AND;
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        if (nbt.hasKey("Kind")) {
            int kind = nbt.getInteger("Kind");
            switch (kind) {
                case 1: 
                case 2: {
                    material = GateDefinition.GateMaterial.IRON;
                    break;
                }
                case 3: 
                case 4: {
                    material = GateDefinition.GateMaterial.GOLD;
                    break;
                }
                case 5: 
                case 6: {
                    material = GateDefinition.GateMaterial.DIAMOND;
                }
            }
            switch (kind) {
                case 2: 
                case 4: 
                case 6: {
                    logic = GateDefinition.GateLogic.OR;
                }
            }
        }
        if (nbt.hasKey("material")) {
            try {
                material = GateDefinition.GateMaterial.valueOf(nbt.getString("material"));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        if (nbt.hasKey("logic")) {
            try {
                logic = GateDefinition.GateLogic.valueOf(nbt.getString("logic"));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        if (nbt.hasKey("direction")) {
            direction = ForgeDirection.getOrientation((int)nbt.getInteger("direction"));
        }
        Gate gate = GateFactory.makeGate(pipe, material, logic, direction);
        gate.readFromNBT(nbt);
        if (nbt.hasKey("Pulser")) {
            NBTTagCompound pulsarTag = nbt.getCompoundTag("Pulser");
            GateExpansionController pulsarCon = GateExpansionPulsar.INSTANCE.makeController(pipe.container);
            pulsarCon.readFromNBT(pulsarTag);
            gate.expansions.put((Object)GateExpansionPulsar.INSTANCE, (Object)pulsarCon);
        }
        NBTTagList exList = nbt.getTagList("expansions", 10);
        for (int i = 0; i < exList.tagCount(); ++i) {
            NBTTagCompound conNBT = exList.getCompoundTagAt(i);
            IGateExpansion ex = GateExpansions.getExpansion(conNBT.getString("type"));
            if (ex == null) continue;
            GateExpansionController con = ex.makeController(pipe.container);
            con.readFromNBT(conNBT.getCompoundTag("data"));
            gate.expansions.put((Object)ex, (Object)con);
        }
        return gate;
    }
}

