/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotPhantom;
import buildcraft.core.gui.slots.SlotValidated;
import buildcraft.transport.TileFilteredBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerFilteredBuffer
extends BuildCraftContainer {
    IInventory playerInventory;
    TileFilteredBuffer filteredBuffer;

    public ContainerFilteredBuffer(InventoryPlayer playerInventory, TileFilteredBuffer tile) {
        super(tile.getSizeInventory());
        this.playerInventory = playerInventory;
        this.filteredBuffer = tile;
        IInventory filters = tile.getFilters();
        for (int col = 0; col < 9; ++col) {
            this.addSlotToContainer(new SlotPhantomLockable(filters, tile, col, 8 + col * 18, 27));
            this.addSlotToContainer(new SlotValidated(tile, col, 8 + col * 18, 61));
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot((IInventory)playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 86 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 144));
        }
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return this.filteredBuffer.isUseableByPlayer(entityPlayer);
    }

    private class SlotPhantomLockable
    extends SlotPhantom {
        final IInventory locks;

        public SlotPhantomLockable(IInventory storage, IInventory locks, int par2, int par3, int par4) {
            super(storage, par2, par3, par4);
            this.locks = locks;
        }

        @Override
        public boolean canAdjust() {
            return this.locks.getStackInSlot(this.getSlotIndex()) == null;
        }
    }
}

