/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BitSetUtils;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.utils.FluidRenderData;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketFluidUpdate
extends PacketCoordinates {
    public static int FLUID_ID_BIT = 0;
    public static int FLUID_AMOUNT_BIT = 1;
    public static int FLUID_DATA_NUM = 2;
    public FluidRenderData[] renderCache = new FluidRenderData[ForgeDirection.values().length];
    public BitSet delta;

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord) {
        super(3, xCoord, yCoord, zCoord);
    }

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord, boolean chunkPacket) {
        super(3, xCoord, yCoord, zCoord);
        this.isChunkDataPacket = chunkPacket;
    }

    public PacketFluidUpdate() {
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        World world = CoreProxy.proxy.getClientWorld();
        if (!world.blockExists(this.posX, this.posY, this.posZ)) {
            return;
        }
        TileEntity entity = world.getTileEntity(this.posX, this.posY, this.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportFluids)) {
            return;
        }
        PipeTransportFluids transLiq = (PipeTransportFluids)pipe.pipe.transport;
        this.renderCache = transLiq.renderCache;
        byte[] dBytes = new byte[2];
        data.readBytes(dBytes);
        this.delta = BitSetUtils.fromByteArray(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_ID_BIT)) {
                short id = data.readShort();
                int amt = this.renderCache[dir.ordinal()] != null ? this.renderCache[dir.ordinal()].amount : 0;
                int color = id != 0 ? data.readInt() : 0xFFFFFF;
                this.renderCache[dir.ordinal()] = new FluidRenderData(id, amt, color);
            }
            if (!this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_AMOUNT_BIT)) continue;
            int amt = Math.min(transLiq.getCapacity(), data.readUnsignedShort());
            if (this.renderCache[dir.ordinal()] != null) {
                this.renderCache[dir.ordinal()].amount = amt;
                continue;
            }
            this.renderCache[dir.ordinal()] = new FluidRenderData(0, amt, 0xFFFFFF);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        byte[] dBytes = BitSetUtils.toByteArray(this.delta, 2);
        data.writeBytes(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            FluidRenderData liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_ID_BIT)) {
                if (liquid != null && liquid.fluidID != 0) {
                    data.writeShort(liquid.fluidID);
                    data.writeInt(liquid.color);
                } else {
                    data.writeShort(0);
                }
            }
            if (!this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_AMOUNT_BIT)) continue;
            if (liquid != null) {
                data.writeShort(liquid.amount);
                continue;
            }
            data.writeShort(0);
        }
    }

    @Override
    public int getID() {
        return 3;
    }
}

