/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.utils.FluidUtils;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.events.PipeEventFluid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class PipeFluidsDiamond
extends Pipe<PipeTransportFluids>
implements IDiamondPipe {
    private FilterInventory filters = new FilterInventory(54, "Filters", 1);

    public PipeFluidsDiamond(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Center.ordinal();
            }
            case DOWN: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Down.ordinal();
            }
            case UP: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Up.ordinal();
            }
            case NORTH: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_North.ordinal();
            }
            case SOUTH: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_South.ordinal();
            }
            case WEST: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_West.ordinal();
            }
            case EAST: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_East.ordinal();
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    @Override
    public int getIconIndexForItem() {
        return PipeIconProvider.TYPE.PipeFluidsDiamond_Item.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.getCurrentEquippedItem() != null && Block.getBlockFromItem((Item)entityplayer.getCurrentEquippedItem().getItem()) instanceof BlockGenericPipe) {
            return false;
        }
        if (!this.container.getWorldObj().isRemote) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 50, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord);
        }
        return true;
    }

    public void eventHandler(PipeEventFluid.FindDest event) {
        Fluid fluidInTank = event.fluidStack.getFluid();
        ArrayList<ForgeDirection> removedDestinations = new ArrayList<ForgeDirection>();
        boolean[] validFilter = new boolean[6];
        boolean isFiltered = false;
        block0: for (ForgeDirection dir : event.destinations) {
            if (!this.container.isPipeConnected(dir) || !this.filters.filteredDirections[dir.ordinal()]) continue;
            for (int slot = dir.ordinal() * 9; slot < dir.ordinal() * 9 + 9; ++slot) {
                if (this.filters.fluids[slot] == null || this.filters.fluids[slot].getID() != fluidInTank.getID()) continue;
                validFilter[dir.ordinal()] = true;
                isFiltered = true;
                continue block0;
            }
        }
        for (ForgeDirection to : event.destinations) {
            if (this.filters.filteredDirections[to.ordinal()] && validFilter[to.ordinal()] || !isFiltered && !this.filters.filteredDirections[to.ordinal()]) continue;
            removedDestinations.add(to);
        }
        for (ForgeDirection dir : removedDestinations) {
            event.destinations.remove(dir);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.filters.markDirty();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        Utils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = Utils.readNBT(data);
        this.readFromNBT(nbt);
    }

    private class FilterInventory
    extends SimpleInventory {
        public boolean[] filteredDirections;
        public Fluid[] fluids;

        public FilterInventory(int size, String invName, int invStackLimit) {
            super(size, invName, invStackLimit);
            this.filteredDirections = new boolean[6];
            this.fluids = new Fluid[54];
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return stack == null || FluidUtils.isFluidContainer(stack);
        }

        @Override
        public void markDirty() {
            int i;
            for (i = 0; i < 6; ++i) {
                this.filteredDirections[i] = false;
            }
            for (i = 0; i < 54; ++i) {
                this.fluids[i] = FluidUtils.getFluidFromItemStack(this.getStackInSlot(i));
                if (this.fluids[i] == null) continue;
                this.filteredDirections[i / 9] = true;
            }
        }
    }
}

