/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.statements.IActionInternal;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.StatementSlot;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.statements.ActionExtractionPreset;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsEmzuli
extends PipeItemsWood
implements IGuiReturnHandler {
    public final byte[] slotColors = new byte[4];
    private final SimpleInventory filters = new SimpleInventory(4, "Filters", 1);
    private final BitSet activeFlags = new BitSet(4);
    private final int filterCount = this.filters.getSizeInventory();
    private int currentFilter = 0;

    public PipeItemsEmzuli(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeItemsEmzuli_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmzuli_Solid.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.getCurrentEquippedItem() != null && Block.getBlockFromItem((Item)entityplayer.getCurrentEquippedItem().getItem()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!this.container.getWorldObj().isRemote) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 53, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord);
        }
        return true;
    }

    @Override
    protected TravelingItem makeItem(double x, double y, double z, ItemStack stack) {
        TravelingItem item = super.makeItem(x, y, z, stack);
        byte color = this.slotColors[this.currentFilter % this.filterCount];
        if (color > 0) {
            item.color = EnumColor.fromId(color - 1);
        }
        return item;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (this.activeFlags.isEmpty()) {
            return null;
        }
        this.incrementFilter();
        if (this.filters.getStackInSlot(this.currentFilter % this.filterCount) == null || !this.activeFlags.get(this.currentFilter % this.filterCount)) {
            return null;
        }
        IInventory inv = InvUtils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    @Override
    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.getAccessibleSlotsFromSide(from.ordinal())) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.stackSize <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!filter.isItemEqual(stack) || !inventory.canExtractItem(i, stack, from.ordinal())) continue;
            if (doRemove) {
                int stackSize = (int)Math.floor(this.battery.useEnergy(10, stack.stackSize * 10, false) / 10);
                return inventory.decrStackSize(i, stackSize);
            }
            return stack;
        }
        return null;
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        this.activeFlags.clear();
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionExtractionPreset)) continue;
            this.setActivePreset(((ActionExtractionPreset)action.statement).color);
        }
    }

    private void setActivePreset(EnumColor color) {
        switch (color) {
            case RED: {
                this.activeFlags.set(0);
                break;
            }
            case BLUE: {
                this.activeFlags.set(1);
                break;
            }
            case GREEN: {
                this.activeFlags.set(2);
                break;
            }
            case YELLOW: {
                this.activeFlags.set(3);
                break;
            }
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = super.getActions();
        result.add(BuildCraftTransport.actionExtractionPresetRed);
        result.add(BuildCraftTransport.actionExtractionPresetBlue);
        result.add(BuildCraftTransport.actionExtractionPresetGreen);
        result.add(BuildCraftTransport.actionExtractionPresetYellow);
        return result;
    }

    @Override
    public void writeGuiData(ByteBuf paramDataOutputStream) {
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer paramEntityPlayer) {
        byte slot = data.readByte();
        this.slotColors[slot] = data.readByte();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.currentFilter = nbt.getInteger("currentFilter");
        for (int slot = 0; slot < this.slotColors.length; ++slot) {
            this.slotColors[slot] = nbt.getByte("slotColors[" + slot + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        nbt.setInteger("currentFilter", this.currentFilter);
        for (int slot = 0; slot < this.slotColors.length; ++slot) {
            nbt.setByte("slotColors[" + slot + "]", this.slotColors[slot]);
        }
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; !(this.filters.getStackInSlot(this.currentFilter % this.filterCount) != null && this.activeFlags.get(this.currentFilter % this.filterCount) || count >= this.filterCount); ++count) {
            ++this.currentFilter;
        }
    }

    private ItemStack getCurrentFilter() {
        return this.filters.getStackInSlot(this.currentFilter % this.filters.getSizeInventory());
    }
}

