/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.utils.ColorUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.StatementSlot;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsLapis
extends Pipe<PipeTransportItems> {
    public PipeItemsLapis(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal();
        }
        return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal() + this.container.getBlockMetadata();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        Item equipped;
        Item item = equipped = player.getCurrentEquippedItem() != null ? player.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.xCoord, this.container.yCoord, this.container.zCoord)) {
            if (player.isSneaking()) {
                this.setColor(this.getColor().getPrevious());
            } else {
                this.setColor(this.getColor().getNext());
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.xCoord, this.container.yCoord, this.container.zCoord);
            return true;
        }
        int color = ColorUtils.getColorIDFromDye(player.getCurrentEquippedItem());
        if (color >= 0 && color < 16) {
            this.setColor(EnumColor.fromId(15 - color));
        }
        return false;
    }

    public EnumColor getColor() {
        return EnumColor.fromId(this.container.getBlockMetadata());
    }

    public void setColor(EnumColor color) {
        if (color.ordinal() != this.container.getBlockMetadata()) {
            this.container.getWorldObj().setBlockMetadataWithNotify(this.container.xCoord, this.container.yCoord, this.container.zCoord, color.ordinal(), 3);
            this.container.scheduleRenderUpdate();
        }
    }

    public void eventHandler(PipeEventItem.ReachedCenter event) {
        event.item.color = this.getColor();
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        event.handled = true;
        TravelingItem item = event.item;
        if (item.getSpeed() > 0.01f) {
            item.setSpeed(item.getSpeed() - 0.0025f);
        }
        if (item.getSpeed() < 0.01f) {
            item.setSpeed(0.01f);
        }
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeColor)) continue;
            this.setColor(((ActionPipeColor)action.statement).color);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = super.getActions();
        result.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        return result;
    }
}

