/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.IStripesPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsStripes
extends Pipe<PipeTransportItems>
implements IEnergyHandler,
IStripesPipe {
    public PipeItemsStripes(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.getWorldObj().isRemote) {
            return;
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        if (this.container.getWorldObj().isRemote) {
            return;
        }
        Position p = new Position(this.container.xCoord, this.container.yCoord, this.container.zCoord, event.direction);
        p.moveForwards(1.0);
        ItemStack stack = event.entity.getEntityItem();
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
        switch (event.direction) {
            case DOWN: {
                player.rotationPitch = 90.0f;
                player.rotationYaw = 0.0f;
                break;
            }
            case UP: {
                player.rotationPitch = 270.0f;
                player.rotationYaw = 0.0f;
                break;
            }
            case NORTH: {
                player.rotationPitch = 0.0f;
                player.rotationYaw = 180.0f;
                break;
            }
            case SOUTH: {
                player.rotationPitch = 0.0f;
                player.rotationYaw = 0.0f;
                break;
            }
            case WEST: {
                player.rotationPitch = 0.0f;
                player.rotationYaw = 90.0f;
                break;
            }
            case EAST: {
                player.rotationPitch = 0.0f;
                player.rotationYaw = 270.0f;
                break;
            }
        }
        for (IStripesHandler handler : PipeManager.stripesHandlers) {
            if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, event.direction, stack, player, this)) continue;
            event.entity = null;
            return;
        }
    }

    @Override
    public void dropItem(ItemStack itemStack, ForgeDirection direction) {
        Position p = new Position(this.container.xCoord, this.container.yCoord, this.container.zCoord, direction);
        p.moveForwards(1.0);
        InvUtils.dropItems(this.getWorld(), itemStack, (int)p.x, (int)p.y, (int)p.z);
    }

    @Override
    public void sendItem(ItemStack itemStack, ForgeDirection direction) {
        TravelingItem newItem = TravelingItem.make((double)this.container.xCoord + 0.5, (float)this.container.yCoord + TransportUtils.getPipeFloorOf(itemStack), (double)this.container.zCoord + 0.5, itemStack);
        ((PipeTransportItems)this.transport).injectItem(newItem, direction);
    }

    @Override
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.Stripes.ordinal();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe tilePipe = (TileGenericPipe)tile;
            if (tilePipe.pipe instanceof PipeItemsStripes) {
                return false;
            }
        }
        return super.canPipeConnect(tile, side);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (maxReceive == 0) {
            return 0;
        }
        if (simulate) {
            return maxReceive;
        }
        ForgeDirection o = this.getOpenOrientation();
        if (o != ForgeDirection.UNKNOWN) {
            Position p = new Position(this.container.xCoord, this.container.yCoord, this.container.zCoord, o);
            p.moveForwards(1.0);
            if (!BlockUtils.isUnbreakableBlock(this.getWorld(), (int)p.x, (int)p.y, (int)p.z)) {
                Block block = this.getWorld().getBlock((int)p.x, (int)p.y, (int)p.z);
                int metadata = this.getWorld().getBlockMetadata((int)p.x, (int)p.y, (int)p.z);
                ItemStack stack = new ItemStack(block, 1, metadata);
                EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
                for (IStripesHandler handler : PipeManager.stripesHandlers) {
                    if (handler.getType() != IStripesHandler.StripesHandlerType.BLOCK_BREAK || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, o, stack, player, this)) continue;
                    return maxReceive;
                }
                ArrayList stacks = block.getDrops(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, metadata, 0);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.sendItem(s, o.getOpposite());
                    }
                }
                this.getWorld().setBlockToAir((int)p.x, (int)p.y, (int)p.z);
            }
        }
        return maxReceive;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 10;
    }
}

