/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.TileBuffer;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PipeLogicWood {
    protected final Pipe<?> pipe;

    public PipeLogicWood(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    private void switchSource() {
        int meta = this.pipe.container.getBlockMetadata();
        ForgeDirection newFacing = null;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection facing = ForgeDirection.getOrientation((int)(i % 6));
            if (!this.isValidFacing(facing)) continue;
            newFacing = facing;
            break;
        }
        if (newFacing == null) {
            newFacing = ForgeDirection.UNKNOWN;
        }
        if (newFacing.ordinal() != meta) {
            this.pipe.container.getWorldObj().setBlockMetadataWithNotify(this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord, newFacing.ordinal(), 3);
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.pipe.container.getBlockMetadata();
        if (meta > 5) {
            this.switchSource();
        } else {
            ForgeDirection facing = ForgeDirection.getOrientation((int)meta);
            if (!this.isValidFacing(facing)) {
                this.switchSource();
            }
        }
    }

    private boolean isValidFacing(ForgeDirection side) {
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        if (this.pipe.container.hasBlockingPluggable(side)) {
            return false;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        if (!this.pipe.container.getWorldObj().isRemote) {
            this.switchSourceIfNeeded();
        }
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord);
            return true;
        }
        return false;
    }

    public void onNeighborBlockChange(int blockId) {
        if (!this.pipe.container.getWorldObj().isRemote) {
            this.switchSourceIfNeeded();
        }
    }
}

